/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.microdom.serialize;

import com.helger.annotation.WillClose;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.io.nonblocking.NonBlockingByteArrayOutputStream;
import com.helger.base.io.nonblocking.NonBlockingStringWriter;
import com.helger.base.io.stream.StreamHelper;
import com.helger.base.state.ESuccess;
import com.helger.io.file.FileHelper;
import com.helger.xml.microdom.IMicroNode;
import com.helger.xml.microdom.serialize.MicroSerializer;
import com.helger.xml.serialize.write.IXMLWriterSettings;
import com.helger.xml.serialize.write.XMLWriterSettings;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.file.Path;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class MicroWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(MicroWriter.class);
    private static final MicroWriter INSTANCE = new MicroWriter();

    private MicroWriter() {
    }

    public static @NonNull ESuccess writeToFile(@NonNull IMicroNode iMicroNode, @NonNull File file) {
        return MicroWriter.writeToFile(iMicroNode, file, XMLWriterSettings.DEFAULT_XML_SETTINGS);
    }

    public static @NonNull ESuccess writeToFile(@NonNull IMicroNode iMicroNode, @NonNull File file, @NonNull IXMLWriterSettings iXMLWriterSettings) {
        ValueEnforcer.notNull((Object)file, (String)"File");
        FileOutputStream fileOutputStream = FileHelper.getOutputStream((File)file);
        if (fileOutputStream == null) {
            return ESuccess.FAILURE;
        }
        return MicroWriter.writeToStream(iMicroNode, fileOutputStream, iXMLWriterSettings);
    }

    public static @NonNull ESuccess writeToFile(@NonNull IMicroNode iMicroNode, @NonNull Path path) {
        return MicroWriter.writeToFile(iMicroNode, path, XMLWriterSettings.DEFAULT_XML_SETTINGS);
    }

    public static @NonNull ESuccess writeToFile(@NonNull IMicroNode iMicroNode, @NonNull Path path, @NonNull IXMLWriterSettings iXMLWriterSettings) {
        ValueEnforcer.notNull((Object)path, (String)"Path");
        return MicroWriter.writeToFile(iMicroNode, path.toFile(), iXMLWriterSettings);
    }

    public static @NonNull ESuccess writeToStream(@NonNull IMicroNode iMicroNode, @WillClose @NonNull OutputStream outputStream) {
        return MicroWriter.writeToStream(iMicroNode, outputStream, XMLWriterSettings.DEFAULT_XML_SETTINGS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static @NonNull ESuccess writeToStream(@NonNull IMicroNode iMicroNode, @WillClose @NonNull OutputStream outputStream, @NonNull IXMLWriterSettings iXMLWriterSettings) {
        ValueEnforcer.notNull((Object)iMicroNode, (String)"Node");
        ValueEnforcer.notNull((Object)outputStream, (String)"OutputStream");
        ValueEnforcer.notNull((Object)iXMLWriterSettings, (String)"Settings");
        try {
            MicroSerializer microSerializer = new MicroSerializer(iXMLWriterSettings);
            microSerializer.write(iMicroNode, outputStream);
            ESuccess eSuccess = ESuccess.SUCCESS;
            return eSuccess;
        }
        finally {
            StreamHelper.close((AutoCloseable)outputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static @NonNull ESuccess writeToWriter(@NonNull IMicroNode iMicroNode, @WillClose @NonNull Writer writer, @NonNull IXMLWriterSettings iXMLWriterSettings) {
        ValueEnforcer.notNull((Object)iMicroNode, (String)"Node");
        ValueEnforcer.notNull((Object)writer, (String)"Writer");
        ValueEnforcer.notNull((Object)iXMLWriterSettings, (String)"Settings");
        try {
            MicroSerializer microSerializer = new MicroSerializer(iXMLWriterSettings);
            microSerializer.write(iMicroNode, writer);
            ESuccess eSuccess = ESuccess.SUCCESS;
            return eSuccess;
        }
        finally {
            StreamHelper.close((AutoCloseable)writer);
        }
    }

    public static @NonNull ESuccess writeToWriter(@NonNull IMicroNode iMicroNode, @WillClose @NonNull Writer writer) {
        return MicroWriter.writeToWriter(iMicroNode, writer, XMLWriterSettings.DEFAULT_XML_SETTINGS);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static @Nullable String getNodeAsString(@NonNull IMicroNode iMicroNode, @NonNull IXMLWriterSettings iXMLWriterSettings) {
        ValueEnforcer.notNull((Object)iMicroNode, (String)"Node");
        ValueEnforcer.notNull((Object)iXMLWriterSettings, (String)"Settings");
        try (NonBlockingStringWriter nonBlockingStringWriter = new NonBlockingStringWriter(51200);){
            if (!MicroWriter.writeToWriter(iMicroNode, (Writer)nonBlockingStringWriter, iXMLWriterSettings).isSuccess()) return null;
            String string = nonBlockingStringWriter.getAsString();
            return string;
        }
        catch (Exception exception) {
            LOGGER.error("Error serializing MicroDOM with settings " + iXMLWriterSettings.toString(), (Throwable)exception);
        }
        return null;
    }

    public static @Nullable String getNodeAsString(@NonNull IMicroNode iMicroNode) {
        return MicroWriter.getNodeAsString(iMicroNode, XMLWriterSettings.DEFAULT_XML_SETTINGS);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static @Nullable byte[] getNodeAsBytes(@NonNull IMicroNode iMicroNode, @NonNull IXMLWriterSettings iXMLWriterSettings) {
        ValueEnforcer.notNull((Object)iMicroNode, (String)"Node");
        ValueEnforcer.notNull((Object)iXMLWriterSettings, (String)"Settings");
        try (NonBlockingByteArrayOutputStream nonBlockingByteArrayOutputStream = new NonBlockingByteArrayOutputStream(51200);){
            if (!MicroWriter.writeToStream(iMicroNode, (OutputStream)nonBlockingByteArrayOutputStream, iXMLWriterSettings).isSuccess()) return null;
            byte[] byArray = nonBlockingByteArrayOutputStream.toByteArray();
            return byArray;
        }
        catch (Exception exception) {
            LOGGER.error("Error serializing MicroDOM with settings " + iXMLWriterSettings.toString(), (Throwable)exception);
        }
        return null;
    }

    public static @Nullable byte[] getNodeAsBytes(@NonNull IMicroNode iMicroNode) {
        return MicroWriter.getNodeAsBytes(iMicroNode, XMLWriterSettings.DEFAULT_XML_SETTINGS);
    }
}

