/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.microdom;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.xml.microdom.AbstractMicroNode;
import com.helger.xml.microdom.EMicroNodeType;
import com.helger.xml.microdom.IMicroNode;
import com.helger.xml.microdom.IMicroText;
import com.helger.xml.microdom.MicroDataAware;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class MicroText
extends AbstractMicroNode
implements IMicroText {
    public static final boolean DEFAULT_IGNORABLE_WHITESPACE = false;
    public static final boolean DEFAULT_ESCAPE = true;
    private final MicroDataAware m_aData;
    private final boolean m_bIgnorableWhitespace;
    private boolean m_bEscape = true;

    public MicroText(@NonNull char[] cArray, @Nonnegative int n, @Nonnegative int n2, boolean bl) {
        this.m_aData = new MicroDataAware(cArray, n, n2);
        this.m_bIgnorableWhitespace = bl;
    }

    public MicroText(@Nullable CharSequence charSequence) {
        this(charSequence, false);
    }

    public MicroText(@Nullable CharSequence charSequence, boolean bl) {
        this.m_aData = new MicroDataAware(charSequence);
        this.m_bIgnorableWhitespace = bl;
    }

    private MicroText(@NonNull MicroDataAware microDataAware, boolean bl, boolean bl2) {
        this.m_aData = microDataAware;
        this.m_bIgnorableWhitespace = bl;
        this.m_bEscape = bl2;
    }

    @Override
    public @NonNull EMicroNodeType getType() {
        return EMicroNodeType.TEXT;
    }

    @Override
    @Nonempty
    public @NonNull String getNodeName() {
        return "#text";
    }

    @Override
    public @NonNull String getNodeValue() {
        return this.getData().toString();
    }

    @Override
    public @NonNull CharSequence getData() {
        return this.m_aData.getData();
    }

    @Override
    public void appendData(@Nullable CharSequence charSequence) {
        this.m_aData.appendData(charSequence);
    }

    @Override
    public void appendData(@NonNull char[] cArray, @Nonnegative int n, @Nonnegative int n2) {
        this.m_aData.appendData(cArray, n, n2);
    }

    @Override
    public void appendData(char c) {
        this.m_aData.appendData(c);
    }

    @Override
    public void prependData(@Nullable CharSequence charSequence) {
        this.m_aData.prependData(charSequence);
    }

    @Override
    public void prependData(@NonNull char[] cArray, @Nonnegative int n, @Nonnegative int n2) {
        this.m_aData.prependData(cArray, n, n2);
    }

    @Override
    public void prependData(char c) {
        this.m_aData.prependData(c);
    }

    @Override
    public void setData(@Nullable CharSequence charSequence) {
        this.m_aData.setData(charSequence);
    }

    @Override
    public boolean isElementContentWhitespace() {
        return this.m_bIgnorableWhitespace;
    }

    @Override
    public boolean isEscape() {
        return this.m_bEscape;
    }

    public @NonNull MicroText setEscape(boolean bl) {
        this.m_bEscape = bl;
        return this;
    }

    @Override
    public @NonNull IMicroText getClone() {
        return new MicroText(this.m_aData.getClone(), this.m_bIgnorableWhitespace, this.m_bEscape);
    }

    @Override
    public boolean isEqualContent(@Nullable IMicroNode iMicroNode) {
        if (iMicroNode == this) {
            return true;
        }
        if (iMicroNode == null || !this.getClass().equals(iMicroNode.getClass())) {
            return false;
        }
        MicroText microText = (MicroText)iMicroNode;
        return this.m_aData.equals(microText.m_aData) && this.m_bIgnorableWhitespace == microText.m_bIgnorableWhitespace;
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("text", (Object)this.getData()).append("ignorableWhitspace", this.m_bIgnorableWhitespace).append("escape", this.m_bEscape).getToString();
    }
}

