/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.sax;

import com.helger.base.location.ILocation;
import com.helger.base.location.SimpleLocation;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.diagnostics.error.IError;
import com.helger.diagnostics.error.SingleError;
import com.helger.diagnostics.error.SingleErrorBuilder;
import com.helger.diagnostics.error.level.EErrorLevel;
import com.helger.diagnostics.error.level.IErrorLevel;
import com.helger.xml.sax.ISAXErrorHandler;
import jakarta.annotation.Nonnull;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class AbstractSAXErrorHandler
implements ISAXErrorHandler {
    protected AbstractSAXErrorHandler() {
    }

    @Nonnull
    public static IError getSaxParseError(@Nonnull IErrorLevel iErrorLevel, @Nonnull SAXParseException sAXParseException) {
        return ((SingleErrorBuilder)((SingleErrorBuilder)((SingleErrorBuilder)((SingleErrorBuilder)SingleError.builder().errorLevel(iErrorLevel)).errorLocation((ILocation)SimpleLocation.create((SAXParseException)sAXParseException))).errorText("[SAX] " + sAXParseException.getMessage())).linkedException((Throwable)sAXParseException)).build();
    }

    protected abstract void internalLog(@Nonnull IErrorLevel var1, @Nonnull SAXParseException var2);

    @Override
    public final void warning(SAXParseException sAXParseException) throws SAXException {
        this.internalLog((IErrorLevel)EErrorLevel.WARN, sAXParseException);
    }

    @Override
    public final void error(SAXParseException sAXParseException) throws SAXException {
        this.internalLog((IErrorLevel)EErrorLevel.ERROR, sAXParseException);
    }

    @Override
    public final void fatalError(SAXParseException sAXParseException) throws SAXException {
        this.internalLog((IErrorLevel)EErrorLevel.FATAL_ERROR, sAXParseException);
    }

    public String toString() {
        return new ToStringGenerator((Object)this).getToString();
    }
}

