/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.mock;

import com.helger.annotation.concurrent.Immutable;
import com.helger.base.reflection.GenericReflection;
import com.helger.unittest.support.TestHelper;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.convert.MicroTypeConverter;
import com.helger.xml.microdom.serialize.MicroWriter;
import jakarta.annotation.Nonnull;
import org.junit.Assert;

@Immutable
public final class XMLTestHelper {
    private XMLTestHelper() {
    }

    public static <T> T testMicroTypeConversion(@Nonnull T t) {
        Assert.assertNotNull(t);
        IMicroElement iMicroElement = MicroTypeConverter.convertToMicroElement(t, "test");
        Assert.assertNotNull((Object)iMicroElement);
        Object obj = MicroTypeConverter.convertToNative(iMicroElement, t.getClass());
        Assert.assertNotNull(obj);
        IMicroElement iMicroElement2 = MicroTypeConverter.convertToMicroElement(obj, "test");
        Assert.assertNotNull((Object)iMicroElement2);
        String string = MicroWriter.getNodeAsString(iMicroElement);
        String string2 = MicroWriter.getNodeAsString(iMicroElement2);
        Assert.assertEquals((String)"XML representation must be identical", (Object)string, (Object)string2);
        TestHelper.testDefaultImplementationWithEqualContentObject(t, obj);
        return (T)GenericReflection.uncheckedCast(obj);
    }
}

