/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.serialize.read;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.callback.CallbackList;
import com.helger.commons.callback.exception.IExceptionCallback;
import com.helger.commons.collection.impl.CommonsEnumMap;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.lang.ICloneable;
import com.helger.commons.string.ToStringGenerator;
import com.helger.xml.EXMLParserFeature;
import com.helger.xml.EXMLParserProperty;
import com.helger.xml.serialize.read.ISAXReaderSettings;
import com.helger.xml.serialize.read.SAXReaderDefaultSettings;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.xml.parsers.SAXParserFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;

@NotThreadSafe
public class SAXReaderSettings
implements ISAXReaderSettings,
ICloneable<SAXReaderSettings> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SAXReaderSettings.class);
    private EntityResolver m_aEntityResolver;
    private DTDHandler m_aDTDHandler;
    private ContentHandler m_aContentHandler;
    private ErrorHandler m_aErrorHandler;
    private final ICommonsMap<EXMLParserProperty, Object> m_aProperties = new CommonsEnumMap(EXMLParserProperty.class);
    private final ICommonsMap<EXMLParserFeature, Boolean> m_aFeatures = new CommonsEnumMap(EXMLParserFeature.class);
    private final CallbackList<IExceptionCallback<Throwable>> m_aExceptionCallbacks = new CallbackList();
    private SAXParserFactory m_aCustomSAXParserFactory;
    private boolean m_bRequiresNewXMLParserExplicitly;

    public SAXReaderSettings() {
        this.setEntityResolver(SAXReaderDefaultSettings.getEntityResolver());
        this.setDTDHandler(SAXReaderDefaultSettings.getDTDHandler());
        this.setContentHandler(SAXReaderDefaultSettings.getContentHandler());
        this.setErrorHandler(SAXReaderDefaultSettings.getErrorHandler());
        this.setPropertyValues((Map<EXMLParserProperty, ?>)SAXReaderDefaultSettings.getAllPropertyValues());
        this.setFeatureValues((Map<EXMLParserFeature, Boolean>)SAXReaderDefaultSettings.getAllFeatureValues());
        this.exceptionCallbacks().set(SAXReaderDefaultSettings.exceptionCallbacks());
        this.setCustomSAXParserFactory(null);
        this.setRequiresNewXMLParserExplicitly(SAXReaderDefaultSettings.isRequiresNewXMLParserExplicitly());
    }

    public SAXReaderSettings(@Nonnull ISAXReaderSettings iSAXReaderSettings) {
        ValueEnforcer.notNull((Object)iSAXReaderSettings, (String)"Other");
        this.setEntityResolver(iSAXReaderSettings.getEntityResolver());
        this.setDTDHandler(iSAXReaderSettings.getDTDHandler());
        this.setContentHandler(iSAXReaderSettings.getContentHandler());
        this.setErrorHandler(iSAXReaderSettings.getErrorHandler());
        this.setPropertyValues((Map<EXMLParserProperty, ?>)iSAXReaderSettings.getAllPropertyValues());
        this.setFeatureValues((Map<EXMLParserFeature, Boolean>)iSAXReaderSettings.getAllFeatureValues());
        this.exceptionCallbacks().set(iSAXReaderSettings.exceptionCallbacks());
        this.setCustomSAXParserFactory(iSAXReaderSettings.getCustomSAXParserFactory());
        this.setRequiresNewXMLParserExplicitly(iSAXReaderSettings.isRequiresNewXMLParserExplicitly());
    }

    @Override
    @Nullable
    public EntityResolver getEntityResolver() {
        return this.m_aEntityResolver;
    }

    @Nonnull
    public final SAXReaderSettings setEntityResolver(@Nullable EntityResolver entityResolver) {
        this.m_aEntityResolver = entityResolver;
        return this;
    }

    @Override
    @Nullable
    public DTDHandler getDTDHandler() {
        return this.m_aDTDHandler;
    }

    @Nonnull
    public final SAXReaderSettings setDTDHandler(@Nullable DTDHandler dTDHandler) {
        this.m_aDTDHandler = dTDHandler;
        return this;
    }

    @Override
    @Nullable
    public ContentHandler getContentHandler() {
        return this.m_aContentHandler;
    }

    @Nonnull
    public final SAXReaderSettings setContentHandler(@Nullable ContentHandler contentHandler) {
        this.m_aContentHandler = contentHandler;
        return this;
    }

    @Override
    @Nullable
    public ErrorHandler getErrorHandler() {
        return this.m_aErrorHandler;
    }

    @Nonnull
    public final SAXReaderSettings setErrorHandler(@Nullable ErrorHandler errorHandler) {
        this.m_aErrorHandler = errorHandler;
        return this;
    }

    @Override
    @Nullable
    public LexicalHandler getLexicalHandler() {
        return (LexicalHandler)this.getPropertyValue(EXMLParserProperty.SAX_LEXICAL_HANDLER);
    }

    @Nonnull
    public final SAXReaderSettings setLexicalHandler(@Nullable LexicalHandler lexicalHandler) {
        return this.setPropertyValue(EXMLParserProperty.SAX_LEXICAL_HANDLER, lexicalHandler);
    }

    @Override
    @Nullable
    public DeclHandler getDeclarationHandler() {
        return (DeclHandler)this.getPropertyValue(EXMLParserProperty.SAX_DECLARATION_HANDLER);
    }

    @Nonnull
    public final SAXReaderSettings setDeclarationHandler(@Nullable DeclHandler declHandler) {
        return this.setPropertyValue(EXMLParserProperty.SAX_DECLARATION_HANDLER, declHandler);
    }

    @Override
    public boolean hasAnyProperties() {
        return !this.m_aProperties.isEmpty();
    }

    @Override
    @Nullable
    public Object getPropertyValue(@Nullable EXMLParserProperty eXMLParserProperty) {
        return eXMLParserProperty == null ? null : this.m_aProperties.get((Object)eXMLParserProperty);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsMap<EXMLParserProperty, Object> getAllPropertyValues() {
        return (ICommonsMap)this.m_aProperties.getClone();
    }

    @Nonnull
    public final SAXReaderSettings setPropertyValue(@Nonnull EXMLParserProperty eXMLParserProperty, @Nullable Object object) {
        ValueEnforcer.notNull((Object)((Object)eXMLParserProperty), (String)"Property");
        if (object != null && eXMLParserProperty.getValueClass() != null && !eXMLParserProperty.getValueClass().isAssignableFrom(object.getClass())) {
            LOGGER.warn("Setting the XML parser property '" + String.valueOf((Object)eXMLParserProperty) + "' to a value of " + String.valueOf(object.getClass()) + " will most likely not be interpreted!");
        }
        if (object != null) {
            this.m_aProperties.put((Object)eXMLParserProperty, object);
        } else {
            this.m_aProperties.remove((Object)eXMLParserProperty);
        }
        return this;
    }

    @Nonnull
    public final SAXReaderSettings setPropertyValues(@Nullable Map<EXMLParserProperty, ?> map) {
        if (map != null) {
            this.m_aProperties.putAll(map);
        }
        return this;
    }

    @Nonnull
    public final SAXReaderSettings removePropertyValue(@Nullable EXMLParserProperty eXMLParserProperty) {
        if (eXMLParserProperty != null) {
            this.m_aProperties.removeObject((Object)eXMLParserProperty);
        }
        return this;
    }

    @Nonnull
    public final SAXReaderSettings removeAllPropertyValues() {
        this.m_aProperties.removeAll();
        return this;
    }

    @Override
    @Nullable
    public Locale getLocale() {
        return (Locale)this.getPropertyValue(EXMLParserProperty.GENERAL_LOCALE);
    }

    @Nonnull
    public SAXReaderSettings setLocale(@Nullable Locale locale) {
        return this.setPropertyValue(EXMLParserProperty.GENERAL_LOCALE, locale);
    }

    @Override
    public boolean hasAnyFeature() {
        return !this.m_aFeatures.isEmpty();
    }

    @Override
    @Nullable
    public Boolean getFeatureValue(@Nullable EXMLParserFeature eXMLParserFeature) {
        return eXMLParserFeature == null ? null : (Boolean)this.m_aFeatures.get((Object)eXMLParserFeature);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsMap<EXMLParserFeature, Boolean> getAllFeatureValues() {
        return (ICommonsMap)this.m_aFeatures.getClone();
    }

    @Nonnull
    public final SAXReaderSettings setFeatureValue(@Nonnull EXMLParserFeature eXMLParserFeature, boolean bl) {
        ValueEnforcer.notNull((Object)((Object)eXMLParserFeature), (String)"Feature");
        this.m_aFeatures.put((Object)eXMLParserFeature, (Object)bl);
        return this;
    }

    @Nonnull
    public final SAXReaderSettings setFeatureValue(@Nonnull EXMLParserFeature eXMLParserFeature, @Nullable Boolean bl) {
        ValueEnforcer.notNull((Object)((Object)eXMLParserFeature), (String)"Feature");
        if (bl == null) {
            this.m_aFeatures.remove((Object)eXMLParserFeature);
        } else {
            this.m_aFeatures.put((Object)eXMLParserFeature, (Object)bl);
        }
        return this;
    }

    @Nonnull
    public final SAXReaderSettings setFeatureValues(@Nullable Map<EXMLParserFeature, Boolean> map) {
        if (map != null) {
            this.m_aFeatures.putAll(map);
        }
        return this;
    }

    @Nonnull
    public final SAXReaderSettings removeFeature(@Nullable EXMLParserFeature eXMLParserFeature) {
        if (eXMLParserFeature != null) {
            this.m_aFeatures.removeObject((Object)eXMLParserFeature);
        }
        return this;
    }

    @Nonnull
    public final SAXReaderSettings removeFeatures(EXMLParserFeature ... eXMLParserFeatureArray) {
        if (eXMLParserFeatureArray != null) {
            for (EXMLParserFeature eXMLParserFeature : eXMLParserFeatureArray) {
                this.m_aFeatures.removeObject((Object)eXMLParserFeature);
            }
        }
        return this;
    }

    @Nonnull
    public final SAXReaderSettings removeAllFeatures() {
        this.m_aFeatures.removeAll();
        return this;
    }

    @Override
    public boolean requiresNewXMLParser() {
        if (this.m_bRequiresNewXMLParserExplicitly) {
            return true;
        }
        if (!this.m_aProperties.isEmpty() || !this.m_aFeatures.isEmpty()) {
            return true;
        }
        return this.m_aEntityResolver != null;
    }

    @Override
    @Nonnull
    @ReturnsMutableObject
    public CallbackList<IExceptionCallback<Throwable>> exceptionCallbacks() {
        return this.m_aExceptionCallbacks;
    }

    @Override
    @Nullable
    public SAXParserFactory getCustomSAXParserFactory() {
        return this.m_aCustomSAXParserFactory;
    }

    @Nonnull
    public final SAXReaderSettings setCustomSAXParserFactory(@Nullable SAXParserFactory sAXParserFactory) {
        this.m_aCustomSAXParserFactory = sAXParserFactory;
        return this;
    }

    @Override
    public boolean isRequiresNewXMLParserExplicitly() {
        return this.m_bRequiresNewXMLParserExplicitly;
    }

    @Nonnull
    public final SAXReaderSettings setRequiresNewXMLParserExplicitly(boolean bl) {
        this.m_bRequiresNewXMLParserExplicitly = bl;
        return this;
    }

    @Nonnull
    public SAXReaderSettings getClone() {
        return new SAXReaderSettings(this);
    }

    @Override
    public void applyToSAXReader(@Nonnull XMLReader xMLReader) {
        ValueEnforcer.notNull((Object)xMLReader, (String)"Parser");
        xMLReader.setContentHandler(this.getContentHandler());
        xMLReader.setDTDHandler(this.getDTDHandler());
        xMLReader.setEntityResolver(this.getEntityResolver());
        xMLReader.setErrorHandler(this.getErrorHandler());
        if (this.hasAnyProperties()) {
            for (Map.Entry entry : this.getAllPropertyValues().entrySet()) {
                ((EXMLParserProperty)((Object)entry.getKey())).applyTo(xMLReader, entry.getValue());
            }
        }
        if (this.hasAnyFeature()) {
            for (Map.Entry entry : this.getAllFeatureValues().entrySet()) {
                ((EXMLParserFeature)((Object)entry.getKey())).applyTo(xMLReader, (boolean)((Boolean)entry.getValue()));
            }
        }
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("EntityResolver", (Object)this.m_aEntityResolver).append("DtdHandler", (Object)this.m_aDTDHandler).append("ContentHandler", (Object)this.m_aContentHandler).append("ErrorHandler", (Object)this.m_aErrorHandler).append("Properties", this.m_aProperties).append("Features", this.m_aFeatures).append("ExceptionHandler", this.m_aExceptionCallbacks).append("CustomSAXParserFactory", (Object)this.m_aCustomSAXParserFactory).append("RequiresNewXMLParserExplicitly", this.m_bRequiresNewXMLParserExplicitly).getToString();
    }

    @Nonnull
    public static SAXReaderSettings createCloneOnDemand(@Nullable ISAXReaderSettings iSAXReaderSettings) {
        if (iSAXReaderSettings == null) {
            return new SAXReaderSettings();
        }
        return new SAXReaderSettings(iSAXReaderSettings);
    }
}

