/*
 * Decompiled with CFR 0.152.
 */
package com.helger.wsclient.mock;

import com.helger.annotation.Nonnegative;
import com.helger.xml.microdom.IMicroDocument;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.serialize.MicroReader;
import jakarta.annotation.Nonnull;
import jakarta.jws.WebService;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WSTestHelper {
    public static final String SUN_JAXWS_XML = "sun-jaxws.xml";
    private static final Logger LOGGER = LoggerFactory.getLogger(WSTestHelper.class);

    private WSTestHelper() {
    }

    @Nonnegative
    public static int testIfAllSunJaxwsFilesAreValid(@Nonnull String string, boolean bl) {
        File file = new File(string, SUN_JAXWS_XML);
        if (file.isFile()) {
            LOGGER.info("Checking file " + file.getAbsolutePath());
            IMicroDocument iMicroDocument = MicroReader.readMicroXML((File)file);
            if (iMicroDocument == null) {
                LOGGER.warn("The file is invalid XML!");
                if (!bl) {
                    throw new IllegalStateException("The file is invalid XML!");
                }
            } else {
                for (IMicroElement iMicroElement : iMicroDocument.getDocumentElement().getAllChildElements("endpoint")) {
                    Class<?> clazz;
                    Object object;
                    String string2;
                    block12: {
                        WebService webService;
                        Class<?> clazz2;
                        String string3;
                        block11: {
                            string2 = iMicroElement.getAttributeValue("name");
                            string3 = iMicroElement.getAttributeValue("implementation");
                            clazz2 = null;
                            try {
                                clazz2 = Class.forName(string3);
                            }
                            catch (Exception exception) {
                                object = "The implementation class '" + string3 + "' of endpoint '" + string2 + "' is invalid - " + exception.getMessage();
                                LOGGER.warn((String)object);
                                if (bl) break block11;
                                throw new IllegalStateException((String)object);
                            }
                        }
                        if (clazz2 == null) continue;
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("Implementation class '" + string3 + "' found");
                        }
                        if ((webService = clazz2.getAnnotation(WebService.class)) == null) {
                            object = "The implementation class '" + string3 + "' is missing the @WebService annotation";
                            LOGGER.warn((String)object);
                            if (bl) continue;
                            throw new IllegalStateException((String)object);
                        }
                        object = webService.endpointInterface();
                        clazz = null;
                        try {
                            clazz = Class.forName((String)object);
                        }
                        catch (Exception exception) {
                            String string4 = "The endpoint interface class '" + (String)object + "' of implementation class '" + string3 + "' is invalid - " + exception.getMessage();
                            LOGGER.warn(string4);
                            if (bl) break block12;
                            throw new IllegalStateException(string4);
                        }
                    }
                    if (clazz == null || clazz.isInterface()) continue;
                    String string5 = "The endpoint interface class '" + (String)object + "' of endpoint '" + string2 + "' is not an interface!";
                    LOGGER.warn(string5);
                    if (bl) continue;
                    throw new IllegalStateException(string5);
                }
            }
        }
        return 0;
    }

    @Nonnegative
    public static int testIfAllSunJaxwsFilesAreValid(boolean bl) {
        int n = 0;
        n += WSTestHelper.testIfAllSunJaxwsFilesAreValid("src/main/resources/WEB-INF", bl);
        return n += WSTestHelper.testIfAllSunJaxwsFilesAreValid("src/main/webapp/WEB-INF", bl);
    }

    public static void testIfAllSunJaxwsFilesAreValid() {
        WSTestHelper.testIfAllSunJaxwsFilesAreValid(false);
    }
}

