/*
 * Decompiled with CFR 0.152.
 */
package com.helger.tree.sort;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.hierarchy.visit.ChildrenProviderHierarchyVisitor;
import com.helger.commons.hierarchy.visit.DefaultHierarchyVisitorCallback;
import com.helger.commons.hierarchy.visit.EHierarchyVisitorReturn;
import com.helger.commons.hierarchy.visit.IHierarchyVisitorCallback;
import com.helger.tree.IBasicTree;
import com.helger.tree.IBasicTreeItem;
import com.helger.tree.ITreeItem;
import java.util.Comparator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class TreeSorter {
    private static final TreeSorter INSTANCE = new TreeSorter();

    private TreeSorter() {
    }

    private static <DATATYPE, ITEMTYPE extends ITreeItem<DATATYPE, ITEMTYPE>> void _sort(@Nonnull IBasicTree<? extends DATATYPE, ITEMTYPE> iBasicTree, final @Nonnull Comparator<? super ITEMTYPE> comparator) {
        ValueEnforcer.notNull(iBasicTree, (String)"Tree");
        ValueEnforcer.notNull(comparator, (String)"Comparator");
        ChildrenProviderHierarchyVisitor.visitFrom(iBasicTree.getRootItem(), (IHierarchyVisitorCallback)new DefaultHierarchyVisitorCallback<ITEMTYPE>(){

            @Nonnull
            public EHierarchyVisitorReturn onItemBeforeChildren(@Nullable ITEMTYPE ITEMTYPE) {
                if (ITEMTYPE != null) {
                    ITEMTYPE.reorderChildItems(comparator);
                }
                return EHierarchyVisitorReturn.CONTINUE;
            }
        }, (boolean)true);
    }

    public static <DATATYPE, ITEMTYPE extends ITreeItem<DATATYPE, ITEMTYPE>> void sort(@Nonnull IBasicTree<? extends DATATYPE, ITEMTYPE> iBasicTree, @Nonnull Comparator<? super DATATYPE> comparator) {
        TreeSorter._sort(iBasicTree, Comparator.comparing(IBasicTreeItem::getData, comparator));
    }

    public static <DATATYPE extends Comparable<? super DATATYPE>, ITEMTYPE extends ITreeItem<DATATYPE, ITEMTYPE>> void sort(@Nonnull IBasicTree<DATATYPE, ITEMTYPE> iBasicTree) {
        TreeSorter._sort(iBasicTree, (iTreeItem, iTreeItem2) -> ((Comparable)iTreeItem.getData()).compareTo(iTreeItem2.getData()));
    }
}

