/*
 * Decompiled with CFR 0.152.
 */
package com.helger.text.format;

import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.string.StringHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.text.format.AbstractFormatterString;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public class FormatterStringSkipPrefixAndSuffix
extends AbstractFormatterString {
    private final String m_sPrefix;
    private final String m_sSuffix;

    public FormatterStringSkipPrefixAndSuffix(@Nonnull String string, @Nonnull String string2) {
        this.m_sPrefix = (String)ValueEnforcer.notNull((Object)string, (String)"Prefix");
        this.m_sSuffix = (String)ValueEnforcer.notNull((Object)string2, (String)"Suffix");
    }

    @Nonnull
    public String getPrefix() {
        return this.m_sPrefix;
    }

    @Nonnull
    public String getSuffix() {
        return this.m_sSuffix;
    }

    @Override
    public String apply(@Nullable Object object) {
        String string = this.getValueAsString(object);
        if (this.m_sPrefix.length() > 0) {
            string = StringHelper.trimStart((String)string, (String)this.m_sPrefix);
        }
        if (this.m_sSuffix.length() > 0) {
            string = StringHelper.trimEnd((String)string, (String)this.m_sSuffix);
        }
        return string;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        FormatterStringSkipPrefixAndSuffix formatterStringSkipPrefixAndSuffix = (FormatterStringSkipPrefixAndSuffix)object;
        return this.m_sPrefix.equals(formatterStringSkipPrefixAndSuffix.m_sPrefix) && this.m_sSuffix.equals(formatterStringSkipPrefixAndSuffix.m_sSuffix);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sPrefix).append((Object)this.m_sSuffix).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("Prefix", (Object)this.m_sPrefix).append("Suffix", (Object)this.m_sSuffix).getToString();
    }

    @Nonnull
    public static FormatterStringSkipPrefixAndSuffix createPrefixOnly(@Nonnull String string) {
        return new FormatterStringSkipPrefixAndSuffix(string, "");
    }

    @Nonnull
    public static FormatterStringSkipPrefixAndSuffix createSuffixOnly(@Nonnull String string) {
        return new FormatterStringSkipPrefixAndSuffix("", string);
    }
}

