/*
 * Decompiled with CFR 0.152.
 */
package com.helger.text.codepoint;

import com.helger.base.enforce.ValueEnforcer;
import com.helger.text.codepoint.AbstractCodepointIterator;
import com.helger.text.codepoint.Codepoint;
import com.helger.text.codepoint.DelegatingCodepointIterator;
import com.helger.text.codepoint.InvalidCharacterException;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.function.IntPredicate;

public class CodepointIteratorRestricted
extends DelegatingCodepointIterator {
    private final IntPredicate m_aFilter;
    private final boolean m_bScanningOnly;
    private final boolean m_bInvert;

    public CodepointIteratorRestricted(@Nonnull AbstractCodepointIterator abstractCodepointIterator, @Nonnull IntPredicate intPredicate) {
        this(abstractCodepointIterator, intPredicate, false);
    }

    public CodepointIteratorRestricted(@Nonnull AbstractCodepointIterator abstractCodepointIterator, @Nonnull IntPredicate intPredicate, boolean bl) {
        this(abstractCodepointIterator, intPredicate, bl, false);
    }

    public CodepointIteratorRestricted(@Nonnull AbstractCodepointIterator abstractCodepointIterator, @Nonnull IntPredicate intPredicate, boolean bl, boolean bl2) {
        super(abstractCodepointIterator);
        this.m_aFilter = (IntPredicate)ValueEnforcer.notNull((Object)intPredicate, (String)"Filter");
        this.m_bScanningOnly = bl;
        this.m_bInvert = bl2;
    }

    @Override
    public boolean hasNext() {
        boolean bl = super.hasNext();
        if (this.m_bScanningOnly) {
            try {
                int n;
                Codepoint codepoint = this.peek(this.position());
                int n2 = n = codepoint == null ? -1 : codepoint.getValue();
                if (bl && n != -1 && this._doFilter(n)) {
                    return false;
                }
            }
            catch (InvalidCharacterException invalidCharacterException) {
                return false;
            }
        }
        return bl;
    }

    @Override
    public Codepoint next() {
        Codepoint codepoint = super.next();
        int n = codepoint.getValue();
        if (n != -1 && this._doFilter(n)) {
            if (this.m_bScanningOnly) {
                this.position(this.position() - 1);
                return null;
            }
            throw new InvalidCharacterException(n);
        }
        return codepoint;
    }

    private boolean _doFilter(int n) {
        boolean bl = this.m_aFilter.test(n);
        return this.m_bInvert ? !bl : bl;
    }

    @Override
    @Nullable
    public char[] nextChars() {
        char[] cArray = super.nextChars();
        if (cArray != null && cArray.length > 0) {
            int n;
            if (cArray.length == 1 && this._doFilter(cArray[0])) {
                if (this.m_bScanningOnly) {
                    this.position(this.position() - 1);
                    return null;
                }
                throw new InvalidCharacterException(cArray[0]);
            }
            if (cArray.length == 2 && this._doFilter(n = Character.toCodePoint(cArray[0], cArray[1]))) {
                if (this.m_bScanningOnly) {
                    this.position(this.position() - 2);
                    return null;
                }
                throw new InvalidCharacterException(n);
            }
        }
        return cArray;
    }
}

