/*
 * Decompiled with CFR 0.152.
 */
package com.helger.statistics.impl;

import com.helger.annotation.CheckForSigned;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.statistics.api.IMutableStatisticsHandlerCounter;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

@ThreadSafe
public class StatisticsHandlerCounter
implements IMutableStatisticsHandlerCounter {
    private final AtomicInteger m_aInvocationCount = new AtomicInteger();
    private final AtomicLong m_aCount = new AtomicLong();

    @Override
    @Nonnegative
    public int getInvocationCount() {
        return this.m_aInvocationCount.intValue();
    }

    @Override
    @CheckForSigned
    public long getCount() {
        return this.m_aCount.longValue();
    }

    @Override
    public void increment(long l) {
        this.m_aInvocationCount.incrementAndGet();
        this.m_aCount.addAndGet(l);
    }
}

