/*
 * Decompiled with CFR 0.152.
 */
package com.helger.settings.exchange.xml;

import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHelper;
import com.helger.settings.ISettings;
import com.helger.settings.factory.ISettingsFactory;
import com.helger.typeconvert.impl.TypeConverter;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.IMicroQName;
import com.helger.xml.microdom.MicroElement;
import com.helger.xml.microdom.MicroQName;
import com.helger.xml.microdom.convert.IMicroTypeConverter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Comparator;
import java.util.Map;

public class SettingsMicroDocumentConverter<T extends ISettings>
implements IMicroTypeConverter<T> {
    private static final String ELEMENT_SETTING = "setting";
    private static final IMicroQName ATTR_NAME = new MicroQName("name");
    private static final IMicroQName ATTR_IS_NULL = new MicroQName("is-null");
    private final ISettingsFactory<T> m_aSettingFactory;

    public SettingsMicroDocumentConverter(@Nonnull ISettingsFactory<T> iSettingsFactory) {
        this.m_aSettingFactory = (ISettingsFactory)ValueEnforcer.notNull(iSettingsFactory, (String)"SettingsFactory");
    }

    @Nonnull
    public ISettingsFactory<T> getSettingsFactory() {
        return this.m_aSettingFactory;
    }

    @Nonnull
    public IMicroElement convertToMicroElement(@Nonnull T t, @Nullable String string, @Nonnull String string2) {
        MicroElement microElement = new MicroElement(string, string2);
        microElement.setAttribute(ATTR_NAME, t.getName());
        for (Map.Entry entry : t.getSortedByKey(Comparator.naturalOrder()).entrySet()) {
            String string3 = (String)entry.getKey();
            Object v = entry.getValue();
            IMicroElement iMicroElement = microElement.addElementNS(string, ELEMENT_SETTING);
            iMicroElement.setAttribute(ATTR_NAME, string3);
            if (v == null) {
                iMicroElement.setAttribute(ATTR_IS_NULL, true);
                continue;
            }
            String string4 = (String)TypeConverter.convert(v, String.class);
            iMicroElement.addText((CharSequence)string4);
        }
        return microElement;
    }

    @Nonnull
    public T convertToNative(IMicroElement iMicroElement) {
        String string = iMicroElement.getAttributeValue(ATTR_NAME);
        if (StringHelper.isEmpty((String)string)) {
            throw new IllegalStateException("Settings 'name' is missing or empty");
        }
        T t = this.m_aSettingFactory.apply(string);
        for (IMicroElement iMicroElement2 : iMicroElement.getAllChildElements()) {
            IMicroElement iMicroElement3;
            String string2 = iMicroElement2.getAttributeValue(ATTR_NAME);
            String string3 = iMicroElement2.hasAttribute(ATTR_IS_NULL) ? null : ((iMicroElement3 = iMicroElement2.getFirstChildElement("value")) != null ? iMicroElement3.getTextContent() : iMicroElement2.getTextContent());
            t.putIn((Object)string2, string3);
        }
        return t;
    }
}

