/*
 * Decompiled with CFR 0.152.
 */
package com.helger.settings.exchange.configfile;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.system.SystemProperties;
import com.helger.commons.traits.IGetterByKeyTrait;
import com.helger.settings.ISettings;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public class ConfigFile
implements IGetterByKeyTrait<String> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigFile.class);
    private final IReadableResource m_aReadResource;
    private final ISettings m_aSettings;

    public ConfigFile(@Nullable IReadableResource iReadableResource, @Nullable ISettings iSettings) {
        this.m_aReadResource = iReadableResource;
        this.m_aSettings = iSettings;
    }

    public boolean isRead() {
        return this.m_aSettings != null;
    }

    @Nullable
    public IReadableResource getReadResource() {
        return this.m_aReadResource;
    }

    @Nullable
    public ISettings getSettings() {
        return this.m_aSettings;
    }

    @Nullable
    public Object getValue(@Nullable String string) {
        return this.m_aSettings == null ? null : this.m_aSettings.getValue(string);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsMap<String, Object> getAllEntries() {
        if (this.m_aSettings == null) {
            return new CommonsHashMap();
        }
        return this.m_aSettings.getClone();
    }

    public void applyAsSystemProperties(String ... stringArray) {
        if (this.isRead() && stringArray != null) {
            for (String string : stringArray) {
                String string2 = this.getAsString(string);
                if (string2 == null) continue;
                SystemProperties.setPropertyValue((String)string, (String)string2);
                if (!LOGGER.isInfoEnabled()) continue;
                LOGGER.info("Set Java system property from configuration: " + string + "=" + string2);
            }
        }
    }

    public void applyAllNetworkSystemProperties() {
        this.applyAsSystemProperties(SystemProperties.getAllJavaNetSystemProperties());
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("ReadResource", (Object)this.m_aReadResource).append("Settings", (Object)this.m_aSettings).getToString();
    }
}

