/*
 * Decompiled with CFR 0.152.
 */
package com.helger.settings;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.state.EChange;
import com.helger.commons.state.IChangeIndicator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.settings.ISettings;
import com.helger.settings.ISettingsWithDefault;
import com.helger.settings.Settings;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class SettingsWithDefault
extends Settings
implements ISettingsWithDefault {
    private final transient ISettings m_aDefaultSettings;

    public SettingsWithDefault(@Nonnull ISettings iSettings) {
        this(iSettings.getName(), iSettings);
    }

    public SettingsWithDefault(@Nonnull @Nonempty String string, @Nonnull ISettings iSettings) {
        super(string);
        this.m_aDefaultSettings = (ISettings)ValueEnforcer.notNull((Object)iSettings, (String)"DefaultSettings");
    }

    @Override
    public boolean containsKeyDirect(@Nullable String string) {
        return super.containsKey((Object)string);
    }

    public boolean containsKey(@Nullable Object object) {
        if (this.containsKeyDirect((String)object)) {
            return true;
        }
        return this.m_aDefaultSettings.containsKey(object);
    }

    @Override
    @Nullable
    public Object getValueDirect(@Nullable String string) {
        return super.getValue((Object)string);
    }

    @Nullable
    public Object getValue(@Nullable String string) {
        Object object = this.getValueDirect(string);
        if (object == null) {
            object = this.m_aDefaultSettings.getValue(string);
        }
        return object;
    }

    @Override
    @Nonnull
    public final ISettings getDefaultSettings() {
        return this.m_aDefaultSettings;
    }

    @Override
    @Nonnull
    public EChange setToDefault(@Nullable String string) {
        Object object = this.m_aDefaultSettings.getValue(string);
        if (object == null) {
            return EChange.UNCHANGED;
        }
        return this.putIn(string, object);
    }

    @Override
    @Nonnull
    public final EChange setAllToDefault() {
        EChange eChange = EChange.UNCHANGED;
        for (String string : this.m_aDefaultSettings.keySet()) {
            eChange = eChange.or((IChangeIndicator)this.setToDefault(string));
        }
        return eChange;
    }

    @Override
    public final boolean isSetToDefault(@Nullable String string) {
        return this.containsKeyDirect(string) && EqualsHelper.equals((Object)this.getValueDirect(string), (Object)this.m_aDefaultSettings.getValue(string));
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        SettingsWithDefault settingsWithDefault = (SettingsWithDefault)object;
        return this.m_aDefaultSettings.equals(settingsWithDefault.m_aDefaultSettings);
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived((int)super.hashCode()).append((Map)((Object)this.m_aDefaultSettings)).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("DefaultSettings", (Object)this.m_aDefaultSettings).getToString();
    }
}

