/*
 * Decompiled with CFR 0.152.
 */
package com.helger.security.random;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringParser;
import com.helger.base.system.SystemProperties;
import com.helger.base.timing.StopWatch;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicInteger;
import org.jspecify.annotations.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class VerySecureRandom {
    public static final int DEFAULT_RE_SEED_INTERVAL = 20;
    private static final Logger LOGGER;
    private static final int SEED_BYTE_COUNT = 64;
    private static final int WARNING_MILLISECONDS_THRESHOLD = 500;
    private static final SecureRandom SECURE_RANDOM;
    private static final AtomicInteger RE_SEED_INTERVAL;
    private static final AtomicInteger COUNTER;
    private static final VerySecureRandom INSTANCE;

    private static @NonNull SecureRandom _createSecureRandomInstance() {
        SecureRandom secureRandom;
        block9: {
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Trying to get SecureRandom: IBMSecureRandom, IBMJCE");
                }
                secureRandom = SecureRandom.getInstance("IBMSecureRandom", "IBMJCE");
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Using SecureRandom: IBMSecureRandom, IBMJCE");
                }
            }
            catch (Exception exception) {
                try {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Trying to get SecureRandom: NativePRNGNonBlocking");
                    }
                    secureRandom = SecureRandom.getInstance("NativePRNGNonBlocking");
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Using SecureRandom: NativePRNGNonBlocking");
                    }
                }
                catch (Exception exception2) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Trying to get default SecureRandom");
                    }
                    secureRandom = new SecureRandom();
                    if (!LOGGER.isDebugEnabled()) break block9;
                    LOGGER.debug("Using default SecureRandom");
                }
            }
        }
        return secureRandom;
    }

    private VerySecureRandom() {
    }

    public static void setReSeedInterval(@Nonnegative int n) {
        ValueEnforcer.isGE0((int)n, (String)"ReseedInterval");
        RE_SEED_INTERVAL.set(n);
    }

    @Nonnegative
    public static int getReSeedInterval() {
        return RE_SEED_INTERVAL.get();
    }

    public static @NonNull SecureRandom getInstance() {
        int n = VerySecureRandom.getReSeedInterval();
        if (n > 0 && COUNTER.incrementAndGet() % n == 0) {
            Duration duration;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Re-seeding VerySecureRandom started");
            }
            if ((duration = StopWatch.runMeasured(() -> SECURE_RANDOM.setSeed(SECURE_RANDOM.generateSeed(64)))).toMillis() > 500L) {
                LOGGER.warn("Re-seeding VerySecureRandom took too long (" + duration.toMillis() + " milliseconds) - you may consider using '/dev/urandom'");
            }
        }
        return SECURE_RANDOM;
    }

    static {
        int n;
        LOGGER = LoggerFactory.getLogger(VerySecureRandom.class);
        RE_SEED_INTERVAL = new AtomicInteger(20);
        COUNTER = new AtomicInteger(0);
        Object object = SystemProperties.getPropertyValueOrNull((String)"ph.securerandom-reseed-interval");
        Integer n2 = StringParser.parseIntObj((String)object);
        if (n2 != null && (n = n2.intValue()) >= 0) {
            LOGGER.info("VerySecureRandom uses by default re-seed interval " + n);
            RE_SEED_INTERVAL.set(n);
        }
        object = VerySecureRandom._createSecureRandomInstance();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Generating intial seed for VerySecureRandom - 64 bytes");
        }
        n2 = StopWatch.createdStarted();
        byte[] byArray = ((SecureRandom)object).generateSeed(64);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Finished generating intial seed for VerySecureRandom");
        }
        SECURE_RANDOM = VerySecureRandom._createSecureRandomInstance();
        try {
            SECURE_RANDOM.setSeed(byArray);
        }
        catch (ProviderException providerException) {
            LOGGER.error("Error setting initial seed on SecureRandom", (Throwable)providerException);
        }
        long l = n2.stopAndGetMillis();
        if (l > 500L) {
            LOGGER.warn("Initially seeding VerySecureRandom took too long (" + l + " milliseconds) - you may consider using '/dev/urandom'");
        }
        INSTANCE = new VerySecureRandom();
    }
}

