/*
 * Decompiled with CFR 0.152.
 */
package com.helger.security.password.hash;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.security.password.salt.IPasswordSalt;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Immutable
public final class PasswordHash {
    public static final int ALGORITHM_NAME_MAX_LENGTH = 100;
    private final String m_sAlgorithmName;
    private final IPasswordSalt m_aSalt;
    private final String m_sPasswordHashValue;

    public PasswordHash(@NonNull @Nonempty String string, @Nullable IPasswordSalt iPasswordSalt, @NonNull @Nonempty String string2) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"AlgorithmName");
        ValueEnforcer.isTrue(() -> string.length() <= 100, (String)"AlgorithmName is too long");
        ValueEnforcer.notEmpty((CharSequence)string2, (String)"PasswordHashValue");
        this.m_sAlgorithmName = string;
        this.m_aSalt = iPasswordSalt;
        this.m_sPasswordHashValue = string2;
    }

    public @NonNull @Nonempty String getAlgorithmName() {
        return this.m_sAlgorithmName;
    }

    public boolean hasSalt() {
        return this.m_aSalt != null;
    }

    public @Nullable IPasswordSalt getSalt() {
        return this.m_aSalt;
    }

    public @Nullable String getSaltAsString() {
        return this.m_aSalt == null ? null : this.m_aSalt.getSaltString();
    }

    public @NonNull @Nonempty String getPasswordHashValue() {
        return this.m_sPasswordHashValue;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        PasswordHash passwordHash = (PasswordHash)object;
        return this.m_sAlgorithmName.equals(passwordHash.m_sAlgorithmName) && EqualsHelper.equals((Object)this.m_aSalt, (Object)passwordHash.m_aSalt) && this.m_sPasswordHashValue.equals(passwordHash.m_sPasswordHashValue);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sAlgorithmName).append((Object)this.m_aSalt).append((Object)this.m_sPasswordHashValue).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("AlgorithmName", (Object)this.m_sAlgorithmName).appendIfNotNull("Salt", (Object)this.m_aSalt).append("PasswordHashValue", (Object)this.m_sPasswordHashValue).getToString();
    }
}

