/*
 * Decompiled with CFR 0.152.
 */
package com.helger.security.keystore;

import com.helger.base.builder.IBuilder;
import com.helger.base.string.StringHelper;
import com.helger.security.keystore.IKeyStoreType;
import com.helger.security.keystore.TrustStoreDescriptor;
import java.security.Provider;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class TrustStoreDescriptorBuilder
implements IBuilder<TrustStoreDescriptor> {
    private IKeyStoreType m_aType;
    private String m_sPath;
    private char[] m_aPassword;
    private Provider m_aProvider;

    public TrustStoreDescriptorBuilder() {
    }

    public TrustStoreDescriptorBuilder(@NonNull TrustStoreDescriptor trustStoreDescriptor) {
        this.type(trustStoreDescriptor.m_aType).path(trustStoreDescriptor.m_sPath).password(trustStoreDescriptor.m_aPassword).provider(trustStoreDescriptor.m_aProvider);
    }

    public final @NonNull TrustStoreDescriptorBuilder type(@Nullable IKeyStoreType iKeyStoreType) {
        this.m_aType = iKeyStoreType;
        return this;
    }

    public final @NonNull TrustStoreDescriptorBuilder path(@Nullable String string) {
        this.m_sPath = string;
        return this;
    }

    public final @NonNull TrustStoreDescriptorBuilder password(@Nullable String string) {
        return this.password(string == null ? null : string.toCharArray());
    }

    public final @NonNull TrustStoreDescriptorBuilder password(char @Nullable [] cArray) {
        this.m_aPassword = cArray;
        return this;
    }

    public final @NonNull TrustStoreDescriptorBuilder provider(@Nullable Provider provider) {
        this.m_aProvider = provider;
        return this;
    }

    public @NonNull TrustStoreDescriptor build() throws IllegalStateException {
        if (this.m_aType == null) {
            throw new IllegalStateException("Type is missing");
        }
        if (StringHelper.isEmpty((String)this.m_sPath)) {
            throw new IllegalStateException("Path is empty");
        }
        if (this.m_aPassword == null) {
            throw new IllegalStateException("Password is missing");
        }
        return new TrustStoreDescriptor(this.m_aType, this.m_sPath, this.m_aPassword, this.m_aProvider);
    }
}

