/*
 * Decompiled with CFR 0.152.
 */
package com.helger.security.authentication.subject;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.security.authentication.subject.IAuthSubject;
import org.jspecify.annotations.NonNull;

@Immutable
public class AuthSubject
implements IAuthSubject {
    private final String m_sID;
    private final String m_sDisplayName;

    public AuthSubject(@NonNull @Nonempty String string, @NonNull @Nonempty String string2) {
        this.m_sID = (String)ValueEnforcer.notEmpty((CharSequence)string, (String)"ID");
        this.m_sDisplayName = (String)ValueEnforcer.notEmpty((CharSequence)string2, (String)"DisplayName");
    }

    public final @NonNull @Nonempty String getID() {
        return this.m_sID;
    }

    public final @NonNull @Nonempty String getDisplayName() {
        return this.m_sDisplayName;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        AuthSubject authSubject = (AuthSubject)object;
        return this.m_sID.equals(authSubject.m_sID) && this.m_sDisplayName.equals(authSubject.m_sDisplayName);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sID).append((Object)this.m_sDisplayName).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("ID", (Object)this.m_sID).append("DisplayName", (Object)this.m_sDisplayName).getToString();
    }
}

