/*
 * Decompiled with CFR 0.152.
 */
package com.helger.security.authentication.result;

import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.state.ISuccessIndicator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.security.authentication.credentials.ICredentialValidationResult;
import com.helger.security.authentication.result.IAuthToken;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class AuthIdentificationResult
implements ISuccessIndicator {
    private final IAuthToken m_aAuthToken;
    private final ICredentialValidationResult m_aCredentialValidationFailure;

    protected AuthIdentificationResult(@Nullable IAuthToken iAuthToken, @Nullable ICredentialValidationResult iCredentialValidationResult) {
        ValueEnforcer.isFalse((iAuthToken == null && iCredentialValidationResult == null ? 1 : 0) != 0, (String)"One parameter must be set");
        ValueEnforcer.isFalse((iAuthToken != null && iCredentialValidationResult != null ? 1 : 0) != 0, (String)"Only one parameter may be set");
        if (iCredentialValidationResult != null && iCredentialValidationResult.isSuccess()) {
            throw new IllegalStateException("Don't call this method for successfuly credential validation!");
        }
        this.m_aAuthToken = iAuthToken;
        this.m_aCredentialValidationFailure = iCredentialValidationResult;
    }

    public boolean isSuccess() {
        return this.m_aAuthToken != null;
    }

    public boolean isFailure() {
        return this.m_aCredentialValidationFailure != null;
    }

    public @Nullable IAuthToken getAuthToken() {
        return this.m_aAuthToken;
    }

    public @Nullable ICredentialValidationResult getCredentialValidationFailure() {
        return this.m_aCredentialValidationFailure;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("AuthToken", (Object)this.m_aAuthToken).append("CredentialValidationFailure", (Object)this.m_aCredentialValidationFailure).getToString();
    }

    public static @NonNull AuthIdentificationResult createSuccess(@NonNull IAuthToken iAuthToken) {
        ValueEnforcer.notNull((Object)iAuthToken, (String)"AuthToken");
        return new AuthIdentificationResult(iAuthToken, null);
    }

    public static @NonNull AuthIdentificationResult createFailure(@NonNull ICredentialValidationResult iCredentialValidationResult) {
        ValueEnforcer.notNull((Object)iCredentialValidationResult, (String)"CredentialValidationFailure");
        return new AuthIdentificationResult(null, iCredentialValidationResult);
    }
}

