/*
 * Decompiled with CFR 0.152.
 */
package com.helger.security.authentication.result;

import com.helger.annotation.concurrent.Immutable;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.datetime.helper.PDTFactory;
import com.helger.security.authentication.result.IAuthIdentification;
import com.helger.security.authentication.subject.IAuthSubject;
import java.time.LocalDateTime;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Immutable
public final class AuthIdentification
implements IAuthIdentification {
    private final IAuthSubject m_aAuthSubject;
    private final LocalDateTime m_aIdentificationDT;

    public AuthIdentification(@Nullable IAuthSubject iAuthSubject) {
        this.m_aAuthSubject = iAuthSubject;
        this.m_aIdentificationDT = PDTFactory.getCurrentLocalDateTime();
    }

    @Override
    public @Nullable IAuthSubject getAuthSubject() {
        return this.m_aAuthSubject;
    }

    @Override
    public @NonNull LocalDateTime getIdentificationDateTime() {
        return this.m_aIdentificationDT;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        AuthIdentification authIdentification = (AuthIdentification)object;
        return EqualsHelper.equals((Object)this.m_aAuthSubject, (Object)authIdentification.m_aAuthSubject) && this.m_aIdentificationDT.equals(authIdentification.m_aIdentificationDT);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_aAuthSubject).append((Object)this.m_aIdentificationDT).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).appendIfNotNull("AuthSubject", (Object)this.m_aAuthSubject).append("IdentificationDT", (Object)this.m_aIdentificationDT).getToString();
    }
}

