/*
 * Decompiled with CFR 0.152.
 */
package com.helger.security.password.salt;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.array.ArrayHelper;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.string.StringHelper;
import com.helger.base.string.StringHex;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.security.password.salt.IPasswordSalt;
import com.helger.security.random.VerySecureRandom;
import java.util.Arrays;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Nonnegative
@Immutable
public final class PasswordSalt
implements IPasswordSalt {
    public static final int DEFAULT_SALT_BYTES = 32;
    private final byte[] m_aSaltBytes;
    private final String m_sSaltString;

    public PasswordSalt(byte @NonNull @Nonempty [] byArray) {
        ValueEnforcer.notEmpty((byte[])byArray, (String)"Bytes");
        this.m_aSaltBytes = byArray;
        this.m_sSaltString = StringHex.getHexEncoded((byte[])byArray);
    }

    @Override
    @Nonnegative
    public int getSaltByteCount() {
        return this.m_aSaltBytes.length;
    }

    @Override
    @ReturnsMutableCopy
    public byte @NonNull @Nonempty [] getSaltBytes() {
        return ArrayHelper.getCopy((byte[])this.m_aSaltBytes);
    }

    @Override
    public @NonNull @Nonempty String getSaltString() {
        return this.m_sSaltString;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        PasswordSalt passwordSalt = (PasswordSalt)object;
        return Arrays.equals(this.m_aSaltBytes, passwordSalt.m_aSaltBytes);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aSaltBytes).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Bytes#", this.m_aSaltBytes.length).getToString();
    }

    public static @NonNull PasswordSalt createRandom() {
        return PasswordSalt.createRandom(32);
    }

    public static @NonNull PasswordSalt createRandom(@Nonnegative int n) {
        ValueEnforcer.isGT0((int)n, (String)"SaltBytes");
        byte[] byArray = new byte[n];
        VerySecureRandom.getInstance().nextBytes(byArray);
        return new PasswordSalt(byArray);
    }

    public static @Nullable PasswordSalt createFromStringMaybe(@Nullable String string) {
        if (StringHelper.isEmpty((String)string)) {
            return null;
        }
        byte[] byArray = StringHex.getHexDecoded((String)string);
        return new PasswordSalt(byArray);
    }
}

