/*
 * Decompiled with CFR 0.152.
 */
package com.helger.security.mac;

import com.helger.annotation.Nonempty;
import com.helger.base.lang.EnumHelper;
import com.helger.base.string.StringHelper;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public enum EMacAlgorithm {
    HMAC_MD5("HmacMD5"),
    HMAC_SHA1("HmacSHA1"),
    HMAC_SHA224("HmacSHA224"),
    HMAC_SHA256("HmacSHA256"),
    HMAC_SHA384("HmacSHA384"),
    HMAC_SHA512("HmacSHA512");

    private final String m_sAlgorithm;

    private EMacAlgorithm(String string2) {
        this.m_sAlgorithm = string2;
    }

    public @NonNull @Nonempty String getAlgorithm() {
        return this.m_sAlgorithm;
    }

    public @NonNull Mac createMac() {
        return this.createMac(null);
    }

    public @NonNull Mac createMac(@Nullable Provider provider) {
        try {
            if (provider == null) {
                return Mac.getInstance(this.m_sAlgorithm);
            }
            return Mac.getInstance(this.m_sAlgorithm, provider);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalStateException("Failed to resolve Mac algorithm '" + this.m_sAlgorithm + "'", noSuchAlgorithmException);
        }
    }

    public @NonNull SecretKeySpec createSecretKey(byte @NonNull [] byArray) {
        return new SecretKeySpec(byArray, this.m_sAlgorithm);
    }

    public static @Nullable EMacAlgorithm getFromStringIgnoreCase(@Nullable String string) {
        if (StringHelper.isEmpty((String)string)) {
            return null;
        }
        return (EMacAlgorithm)EnumHelper.findFirst(EMacAlgorithm.class, eMacAlgorithm -> eMacAlgorithm.m_sAlgorithm.equalsIgnoreCase(string));
    }
}

