/*
 * Decompiled with CFR 0.152.
 */
package com.helger.security.authentication.credentials;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.CodingStyleguideUnaware;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.spi.ServiceLoaderHelper;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.security.authentication.credentials.IAuthCredentialToSubjectResolverSPI;
import com.helger.security.authentication.credentials.IAuthCredentials;
import com.helger.security.authentication.subject.IAuthSubject;
import java.util.List;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Immutable
public final class AuthCredentialToSubjectResolverManager {
    @CodingStyleguideUnaware
    private static final List<IAuthCredentialToSubjectResolverSPI> HDL_LIST = ServiceLoaderHelper.getAllSPIImplementations(IAuthCredentialToSubjectResolverSPI.class);

    private AuthCredentialToSubjectResolverManager() {
    }

    @ReturnsMutableCopy
    public static @NonNull ICommonsList<IAuthCredentialToSubjectResolverSPI> getAllAuthCredentialToSubjectResolvers() {
        return new CommonsArrayList(HDL_LIST);
    }

    @Nonnegative
    public static int getAuthCredentialToSubjectResolverCount() {
        return HDL_LIST.size();
    }

    public static @Nullable IAuthSubject getSubjectFromCredentials(@NonNull IAuthCredentials iAuthCredentials) {
        for (IAuthCredentialToSubjectResolverSPI iAuthCredentialToSubjectResolverSPI : HDL_LIST) {
            IAuthSubject iAuthSubject;
            if (!iAuthCredentialToSubjectResolverSPI.supportsCredentials(iAuthCredentials) || (iAuthSubject = iAuthCredentialToSubjectResolverSPI.getSubjectFromCredentials(iAuthCredentials)) == null) continue;
            return iAuthSubject;
        }
        return null;
    }
}

