/*
 * Decompiled with CFR 0.152.
 */
package com.helger.security.revocation;

import java.security.cert.PKIXRevocationChecker;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import org.jspecify.annotations.NonNull;

public enum ERevocationCheckMode {
    OCSP_BEFORE_CRL(true, true, new HashSet<PKIXRevocationChecker.Option>()),
    OCSP(true, false, EnumSet.of(PKIXRevocationChecker.Option.NO_FALLBACK)),
    CRL_BEFORE_OCSP(true, true, EnumSet.of(PKIXRevocationChecker.Option.PREFER_CRLS)),
    CRL(false, true, EnumSet.of(PKIXRevocationChecker.Option.PREFER_CRLS, PKIXRevocationChecker.Option.NO_FALLBACK)),
    NONE(false, false, new HashSet<PKIXRevocationChecker.Option>());

    private final boolean m_bOCSP;
    private final boolean m_bCRL;
    private final Set<PKIXRevocationChecker.Option> m_aOptions;

    private ERevocationCheckMode(@NonNull boolean bl, boolean bl2, Set<PKIXRevocationChecker.Option> set) {
        this.m_bOCSP = bl;
        this.m_bCRL = bl2;
        this.m_aOptions = set;
    }

    public boolean isOCSP() {
        return this.m_bOCSP;
    }

    public boolean isCRL() {
        return this.m_bCRL;
    }

    public boolean isOnlyOne() {
        return this.m_bOCSP && !this.m_bCRL || this.m_bCRL && !this.m_bOCSP;
    }

    public boolean isNone() {
        return !this.m_bOCSP && !this.m_bCRL;
    }

    public void addAllOptionsTo(@NonNull Collection<? super PKIXRevocationChecker.Option> collection) {
        collection.addAll(this.m_aOptions);
    }
}

