/*
 * Decompiled with CFR 0.152.
 */
package com.helger.security.messagedigest;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.WillClose;
import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.ReturnsMutableObject;
import com.helger.base.array.bytes.ByteArrayWrapper;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.io.iface.IHasByteArray;
import com.helger.base.io.stream.StreamHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.security.messagedigest.EMessageDigestAlgorithm;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import org.jspecify.annotations.NonNull;

@Immutable
public class MessageDigestValue
implements IHasByteArray {
    public static final boolean DEFAULT_COPY_NEEDED = true;
    private final EMessageDigestAlgorithm m_eAlgorithm;
    private final ByteArrayWrapper m_aBytes;

    public MessageDigestValue(@NonNull EMessageDigestAlgorithm eMessageDigestAlgorithm, @Nonempty @NonNull byte[] byArray) {
        this(eMessageDigestAlgorithm, byArray, true);
    }

    public MessageDigestValue(@NonNull EMessageDigestAlgorithm eMessageDigestAlgorithm, @Nonempty @NonNull byte[] byArray, boolean bl) {
        ValueEnforcer.notNull((Object)((Object)eMessageDigestAlgorithm), (String)"Algorithm");
        ValueEnforcer.notEmpty((byte[])byArray, (String)"DigestBytes");
        this.m_eAlgorithm = eMessageDigestAlgorithm;
        this.m_aBytes = new ByteArrayWrapper(byArray, bl);
    }

    public @NonNull EMessageDigestAlgorithm getAlgorithm() {
        return this.m_eAlgorithm;
    }

    public boolean isCopy() {
        return this.m_aBytes.isCopy();
    }

    @Nonempty
    @ReturnsMutableObject
    public @NonNull byte[] bytes() {
        return this.m_aBytes.bytes();
    }

    @Nonnegative
    public int size() {
        return this.m_aBytes.size();
    }

    @Nonnegative
    public int getOffset() {
        return 0;
    }

    @Nonempty
    public @NonNull String getHexEncodedDigestString() {
        return this.m_aBytes.getHexEncoded();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        MessageDigestValue messageDigestValue = (MessageDigestValue)object;
        return this.m_eAlgorithm.equals((Object)messageDigestValue.m_eAlgorithm) && this.m_aBytes.equals((Object)messageDigestValue.m_aBytes);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_eAlgorithm).append((Object)this.m_aBytes).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Algorithm", (Enum)this.m_eAlgorithm).append("Bytes", (Object)this.m_aBytes).getToString();
    }

    public static @NonNull MessageDigestValue create(@NonNull byte[] byArray, @NonNull EMessageDigestAlgorithm eMessageDigestAlgorithm) {
        MessageDigest messageDigest = eMessageDigestAlgorithm.createMessageDigest();
        messageDigest.update(byArray);
        return new MessageDigestValue(eMessageDigestAlgorithm, messageDigest.digest(), false);
    }

    public static @NonNull MessageDigestValue create(@WillClose @NonNull InputStream inputStream, @NonNull EMessageDigestAlgorithm eMessageDigestAlgorithm) throws IOException {
        MessageDigest messageDigest = eMessageDigestAlgorithm.createMessageDigest();
        StreamHelper.readUntilEOF((InputStream)inputStream, (byArray, n) -> messageDigest.update((byte[])byArray, 0, n));
        return new MessageDigestValue(eMessageDigestAlgorithm, messageDigest.digest(), false);
    }
}

