/*
 * Decompiled with CFR 0.152.
 */
package com.helger.security.keystore;

import com.helger.annotation.Nonempty;
import com.helger.annotation.style.ReturnsMutableObject;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.security.keystore.IKeyStoreAndKeyDescriptor;
import com.helger.security.keystore.IKeyStoreType;
import com.helger.security.keystore.KeyStoreAndKeyDescriptorBuilder;
import com.helger.security.keystore.KeyStoreHelper;
import com.helger.security.keystore.LoadedKey;
import com.helger.security.keystore.LoadedKeyStore;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.security.KeyStore;
import java.security.Provider;

public class KeyStoreAndKeyDescriptor
implements IKeyStoreAndKeyDescriptor {
    final IKeyStoreType m_aType;
    final String m_sPath;
    final char[] m_aPassword;
    final Provider m_aProvider;
    final String m_sKeyAlias;
    final char[] m_aKeyPassword;
    private LoadedKeyStore m_aLKS;
    private LoadedKey<KeyStore.PrivateKeyEntry> m_aLK;

    public KeyStoreAndKeyDescriptor(@Nonnull IKeyStoreType iKeyStoreType, @Nonnull @Nonempty String string, @Nonnull char[] cArray, @Nullable Provider provider, @Nonnull @Nonempty String string2, @Nonnull char[] cArray2) {
        ValueEnforcer.notNull((Object)iKeyStoreType, (String)"Type");
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Path");
        ValueEnforcer.notNull((Object)cArray, (String)"Password");
        ValueEnforcer.notEmpty((CharSequence)string2, (String)"KeyAlias");
        ValueEnforcer.notNull((Object)cArray2, (String)"KeyPassword");
        this.m_aType = iKeyStoreType;
        this.m_sPath = string;
        this.m_aPassword = cArray;
        this.m_aProvider = provider;
        this.m_sKeyAlias = string2;
        this.m_aKeyPassword = cArray2;
    }

    @Override
    @Nonnull
    public final IKeyStoreType getKeyStoreType() {
        return this.m_aType;
    }

    @Override
    @Nonnull
    @Nonempty
    public final String getKeyStorePath() {
        return this.m_sPath;
    }

    @Override
    @Nonnull
    @ReturnsMutableObject
    public final char[] getKeyStorePassword() {
        return this.m_aPassword;
    }

    @Override
    @Nullable
    public final Provider getProvider() {
        return this.m_aProvider;
    }

    @Override
    @Nonnull
    public LoadedKeyStore loadKeyStore() {
        LoadedKeyStore loadedKeyStore = this.m_aLKS;
        if (loadedKeyStore == null) {
            loadedKeyStore = this.m_aLKS = KeyStoreHelper.loadKeyStore(this.m_aType, this.m_sPath, this.m_aPassword, this.m_aProvider);
        }
        return loadedKeyStore;
    }

    @Override
    @Nonnull
    @Nonempty
    public final String getKeyAlias() {
        return this.m_sKeyAlias;
    }

    @Override
    @Nonnull
    @ReturnsMutableObject
    public final char[] getKeyPassword() {
        return this.m_aKeyPassword;
    }

    @Override
    @Nonnull
    public LoadedKey<KeyStore.PrivateKeyEntry> loadKey() {
        LoadedKey<KeyStore.PrivateKeyEntry> loadedKey = this.m_aLK;
        if (loadedKey == null) {
            loadedKey = this.m_aLK = KeyStoreHelper.loadPrivateKey(this.loadKeyStore().getKeyStore(), this.m_sPath, this.m_sKeyAlias, this.m_aKeyPassword);
        }
        return loadedKey;
    }

    public String toString() {
        return new ToStringGenerator(null).append("Type", (Object)this.m_aType).append("Path", (Object)this.m_sPath).appendPassword("Password").appendIfNotNull("Provider", (Object)this.m_aProvider).append("KeyAlias", (Object)this.m_sKeyAlias).appendPassword("KeyPassword").getToString();
    }

    @Nonnull
    public static KeyStoreAndKeyDescriptorBuilder builder() {
        return new KeyStoreAndKeyDescriptorBuilder();
    }

    @Nonnull
    public static KeyStoreAndKeyDescriptorBuilder builder(@Nonnull KeyStoreAndKeyDescriptor keyStoreAndKeyDescriptor) {
        return new KeyStoreAndKeyDescriptorBuilder(keyStoreAndKeyDescriptor);
    }
}

