/*
 * Decompiled with CFR 0.152.
 */
package com.helger.security.crl;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.timing.StopWatch;
import com.helger.commons.url.EURLProtocol;
import com.helger.commons.url.IURLDownloader;
import com.helger.security.crl.CRLHelper;
import java.security.cert.CRL;
import java.security.cert.X509CRL;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CRLDownloader {
    private static final Logger LOGGER = LoggerFactory.getLogger(CRLDownloader.class);
    private final IURLDownloader m_aURLDownloader;

    public CRLDownloader() {
        this(IURLDownloader.createDefault());
    }

    public CRLDownloader(@Nonnull IURLDownloader iURLDownloader) {
        ValueEnforcer.notNull((Object)iURLDownloader, (String)"UrlDownloader");
        this.m_aURLDownloader = iURLDownloader;
    }

    @Nonnull
    public final IURLDownloader getURLDownloader() {
        return this.m_aURLDownloader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public CRL downloadCRL(@Nonnull String string) {
        if (EURLProtocol.HTTP.isUsedInURL(string) || EURLProtocol.HTTPS.isUsedInURL(string)) {
            LOGGER.info("Downloading CRL from URL '" + string + "'");
            StopWatch stopWatch = StopWatch.createdStarted();
            int n = 0;
            try {
                byte[] byArray = this.getURLDownloader().downloadURL(string);
                if (byArray != null) {
                    n = byArray.length;
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Finished downloading CRL and received " + n + " bytes");
                    }
                    X509CRL x509CRL = CRLHelper.convertToCRL(byArray);
                    return x509CRL;
                }
                LOGGER.error("Failed to download CRL from URL '" + string + "' - null array returned");
            }
            catch (Exception exception) {
                LOGGER.error("Error downloading CRL from URL '" + string + "'", (Throwable)exception);
            }
            finally {
                stopWatch.stop();
                if (stopWatch.getMillis() > 1000L) {
                    LOGGER.info("Downloading the CRL from '" + string + "' took " + stopWatch.getMillis() + " milliseconds for " + n + " bytes");
                }
            }
        }
        return null;
    }

    public String toString() {
        return new ToStringGenerator(null).append("URLDownloader", (Object)this.m_aURLDownloader).getToString();
    }
}

