/*
 * Decompiled with CFR 0.152.
 */
package com.helger.security.revocation;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.security.crl.CRLCache;
import com.helger.security.revocation.ERevocationCheckMode;
import java.security.GeneralSecurityException;
import java.security.cert.CertPathValidatorException;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class CertificateRevocationCheckerDefaults {
    public static final ERevocationCheckMode DEFAULT_REVOCATION_CHECK_MODE = ERevocationCheckMode.CRL;
    public static final boolean DEFAULT_ALLOW_SOFT_FAIL = false;
    public static final boolean DEFAULT_ALLOW_EXEC_SYNC = true;
    public static final boolean DEFAULT_CACHE_REVOCATION_CHECK_RESULTS = true;
    public static final Duration DEFAULT_REVOCATION_CHECK_CACHING_DURATION = Duration.ofHours(6L);
    private static final Logger LOGGER = LoggerFactory.getLogger(CertificateRevocationCheckerDefaults.class);
    private static final SimpleReadWriteLock RW_LOCK = new SimpleReadWriteLock();
    @GuardedBy(value="RW_LOCK")
    private static ERevocationCheckMode s_eRevocationCheckMode = DEFAULT_REVOCATION_CHECK_MODE;
    @GuardedBy(value="RW_LOCK")
    private static Consumer<? super GeneralSecurityException> s_aExceptionHdl = generalSecurityException -> LOGGER.warn("Certificate is revoked", (Throwable)generalSecurityException);
    private static final AtomicBoolean ALLOW_SOFT_FAIL = new AtomicBoolean(false);
    @GuardedBy(value="RW_LOCK")
    private static Consumer<? super List<? extends CertPathValidatorException>> s_aSoftFailExceptionHdl = list -> LOGGER.warn("Certificate revocation check succeeded but has messages: " + String.valueOf(list));
    private static final AtomicBoolean ALLOW_EXEC_SYNC = new AtomicBoolean(true);
    @GuardedBy(value="RW_LOCK")
    private static CRLCache s_aDefaultCRLCache = CRLCache.createDefault();
    private static final AtomicBoolean CACHE_REVOCATION_RESULTS = new AtomicBoolean(true);

    private CertificateRevocationCheckerDefaults() {
    }

    @Nonnull
    public static ERevocationCheckMode getRevocationCheckMode() {
        return (ERevocationCheckMode)((Object)RW_LOCK.readLockedGet(() -> s_eRevocationCheckMode));
    }

    public static void setRevocationCheckMode(@Nonnull ERevocationCheckMode eRevocationCheckMode) {
        ValueEnforcer.notNull((Object)((Object)eRevocationCheckMode), (String)"RevocationCheckMode");
        RW_LOCK.writeLocked(() -> {
            s_eRevocationCheckMode = eRevocationCheckMode;
        });
        LOGGER.info("Global CertificateRevocationChecker revocation mode was set to: " + String.valueOf((Object)eRevocationCheckMode));
    }

    @Nonnull
    public static Consumer<? super GeneralSecurityException> getExceptionHdl() {
        return (Consumer)RW_LOCK.readLockedGet(() -> s_aExceptionHdl);
    }

    public static void setExceptionHdl(@Nonnull Consumer<? super GeneralSecurityException> consumer) {
        ValueEnforcer.notNull(consumer, (String)"ExceptionHdl");
        RW_LOCK.writeLocked(() -> {
            s_aExceptionHdl = consumer;
        });
    }

    public static boolean isAllowSoftFail() {
        return ALLOW_SOFT_FAIL.get();
    }

    public static void setAllowSoftFail(boolean bl) {
        ALLOW_SOFT_FAIL.set(bl);
        LOGGER.info("Global CertificateRevocationChecker allows for soft fail: " + bl);
    }

    @Nonnull
    public static Consumer<? super List<CertPathValidatorException>> getSoftFailExceptionHdl() {
        return (Consumer)RW_LOCK.readLockedGet(() -> s_aSoftFailExceptionHdl);
    }

    public static void setSoftFailExceptionHdl(@Nonnull Consumer<? super List<? extends CertPathValidatorException>> consumer) {
        ValueEnforcer.notNull(consumer, (String)"SoftFailExceptionHdl");
        RW_LOCK.writeLocked(() -> {
            s_aSoftFailExceptionHdl = consumer;
        });
    }

    public static boolean isExecuteInSynchronizedBlock() {
        return ALLOW_EXEC_SYNC.get();
    }

    public static void setExecuteInSynchronizedBlock(boolean bl) {
        ALLOW_EXEC_SYNC.set(bl);
        LOGGER.info("Global CertificateRevocationChecker is executed synchronously: " + bl);
    }

    @Nonnull
    public static CRLCache getDefaultCRLCache() {
        return (CRLCache)RW_LOCK.readLockedGet(() -> s_aDefaultCRLCache);
    }

    public static void setDefaultCRLCache(@Nonnull CRLCache cRLCache) {
        ValueEnforcer.notNull((Object)cRLCache, (String)"CRLCache");
        RW_LOCK.writeLocked(() -> {
            s_aDefaultCRLCache = cRLCache;
        });
        LOGGER.info("Global default CRL Cache is set to: " + String.valueOf(cRLCache));
    }

    public static boolean isCacheRevocationCheckResults() {
        return CACHE_REVOCATION_RESULTS.get();
    }

    public static void setCacheRevocationCheckResults(boolean bl) {
        CACHE_REVOCATION_RESULTS.set(bl);
        LOGGER.info("Global cache revocation check results enabled: " + bl);
    }
}

