/*
 * Decompiled with CFR 0.152.
 */
package com.helger.security.revocation;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.builder.IBuilder;
import com.helger.commons.callback.IThrowingRunnable;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.CommonsHashSet;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.datetime.PDTFactory;
import com.helger.commons.state.ETriState;
import com.helger.commons.timing.StopWatch;
import com.helger.commons.traits.IGenericImplTrait;
import com.helger.security.crl.CRLCache;
import com.helger.security.crl.CRLHelper;
import com.helger.security.keystore.KeyStoreHelper;
import com.helger.security.revocation.CertificateRevocationCheckerDefaults;
import com.helger.security.revocation.ERevocationCheckMode;
import com.helger.security.revocation.ERevoked;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.Security;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathParameters;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.PKIXRevocationChecker;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public abstract class AbstractRevocationCheckBuilder<IMPLTYPE extends AbstractRevocationCheckBuilder<IMPLTYPE>>
implements IBuilder<ERevoked>,
IGenericImplTrait<IMPLTYPE> {
    public static final Duration DEFAULT_EXECUTION_WARN_DURATION = Duration.ofMillis(500L);
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractRevocationCheckBuilder.class);
    private X509Certificate m_aCert;
    private final ICommonsList<X509Certificate> m_aValidCAs = new CommonsArrayList();
    private Date m_aCheckDate;
    private ERevocationCheckMode m_eCheckMode;
    private Consumer<? super GeneralSecurityException> m_aExceptionHdl;
    private ETriState m_eAllowSoftFail = ETriState.UNDEFINED;
    private Consumer<? super List<CertPathValidatorException>> m_aSoftFailExceptionHdl;
    private ETriState m_eExecuteInSynchronizedBlock = ETriState.UNDEFINED;
    private Duration m_aExecutionDurationWarn = DEFAULT_EXECUTION_WARN_DURATION;
    private CRLCache m_aCRLCache = CertificateRevocationCheckerDefaults.getDefaultCRLCache();

    @Nullable
    public final X509Certificate certificate() {
        return this.m_aCert;
    }

    @Nonnull
    public final IMPLTYPE certificate(@Nullable X509Certificate x509Certificate) {
        this.m_aCert = x509Certificate;
        return (IMPLTYPE)((AbstractRevocationCheckBuilder)this.thisAsT());
    }

    @Nonnull
    public final IMPLTYPE validCA(@Nullable X509Certificate x509Certificate) {
        this.m_aValidCAs.set((Object)x509Certificate);
        return (IMPLTYPE)((AbstractRevocationCheckBuilder)this.thisAsT());
    }

    @Nonnull
    public final IMPLTYPE validCAs(@Nullable Iterable<? extends X509Certificate> iterable) {
        this.m_aValidCAs.setAll(iterable);
        return (IMPLTYPE)((AbstractRevocationCheckBuilder)this.thisAsT());
    }

    @Nonnull
    public final IMPLTYPE validCAs(X509Certificate ... x509CertificateArray) {
        this.m_aValidCAs.setAll((Object[])x509CertificateArray);
        return (IMPLTYPE)((AbstractRevocationCheckBuilder)this.thisAsT());
    }

    @Nonnull
    public final IMPLTYPE validCAs(@Nullable KeyStore keyStore) {
        return this.validCAs((Iterable<? extends X509Certificate>)KeyStoreHelper.getAllTrustedCertificates(keyStore));
    }

    @Nonnull
    public final IMPLTYPE addValidCA(@Nullable X509Certificate x509Certificate) {
        if (x509Certificate != null) {
            this.m_aValidCAs.add((Object)x509Certificate);
        }
        return (IMPLTYPE)((AbstractRevocationCheckBuilder)this.thisAsT());
    }

    @Nonnull
    public final IMPLTYPE addValidCAs(@Nullable Iterable<? extends X509Certificate> iterable) {
        this.m_aValidCAs.addAll(iterable);
        return (IMPLTYPE)((AbstractRevocationCheckBuilder)this.thisAsT());
    }

    @Nonnull
    public final IMPLTYPE addValidCAs(X509Certificate ... x509CertificateArray) {
        this.m_aValidCAs.addAll((Object[])x509CertificateArray);
        return (IMPLTYPE)((AbstractRevocationCheckBuilder)this.thisAsT());
    }

    @Nonnull
    public final IMPLTYPE addValidCAs(@Nullable KeyStore keyStore) {
        return this.addValidCAs((Iterable<? extends X509Certificate>)KeyStoreHelper.getAllTrustedCertificates(keyStore));
    }

    @Nullable
    public final Date checkDate() {
        return this.m_aCheckDate;
    }

    @Nonnull
    public final IMPLTYPE checkDateNow() {
        return this.checkDate((Date)null);
    }

    @Nonnull
    public final IMPLTYPE checkDate(@Nullable LocalDateTime localDateTime) {
        return this.checkDate(localDateTime == null ? null : PDTFactory.createDate((LocalDateTime)localDateTime));
    }

    @Nonnull
    public final IMPLTYPE checkDate(@Nullable OffsetDateTime offsetDateTime) {
        return this.checkDate(offsetDateTime == null ? null : PDTFactory.createDate((OffsetDateTime)offsetDateTime));
    }

    @Nonnull
    public final IMPLTYPE checkDate(@Nullable ZonedDateTime zonedDateTime) {
        return this.checkDate(zonedDateTime == null ? null : PDTFactory.createDate((ZonedDateTime)zonedDateTime));
    }

    @Nonnull
    public final IMPLTYPE checkDate(@Nullable Date date) {
        this.m_aCheckDate = date;
        return (IMPLTYPE)((AbstractRevocationCheckBuilder)this.thisAsT());
    }

    @Nonnull
    public final IMPLTYPE checkMode(@Nullable ERevocationCheckMode eRevocationCheckMode) {
        this.m_eCheckMode = eRevocationCheckMode;
        return (IMPLTYPE)((AbstractRevocationCheckBuilder)this.thisAsT());
    }

    @Nonnull
    public final IMPLTYPE exceptionHandler(@Nullable Consumer<? super GeneralSecurityException> consumer) {
        this.m_aExceptionHdl = consumer;
        return (IMPLTYPE)((AbstractRevocationCheckBuilder)this.thisAsT());
    }

    @Nonnull
    public final IMPLTYPE allowSoftFail(boolean bl) {
        this.m_eAllowSoftFail = ETriState.valueOf((boolean)bl);
        return (IMPLTYPE)((AbstractRevocationCheckBuilder)this.thisAsT());
    }

    @Nonnull
    public final IMPLTYPE allowSoftFailUndefined() {
        this.m_eAllowSoftFail = ETriState.UNDEFINED;
        return (IMPLTYPE)((AbstractRevocationCheckBuilder)this.thisAsT());
    }

    @Nonnull
    public final IMPLTYPE softFailExceptionHandler(@Nullable Consumer<? super List<CertPathValidatorException>> consumer) {
        this.m_aSoftFailExceptionHdl = consumer;
        return (IMPLTYPE)((AbstractRevocationCheckBuilder)this.thisAsT());
    }

    @Nonnull
    public final IMPLTYPE executeInSynchronizedBlock(boolean bl) {
        this.m_eExecuteInSynchronizedBlock = ETriState.valueOf((boolean)bl);
        return (IMPLTYPE)((AbstractRevocationCheckBuilder)this.thisAsT());
    }

    @Nonnull
    public final IMPLTYPE executionDurationWarnMS(long l) {
        return this.executionDurationWarn(Duration.ofMillis(l));
    }

    @Nonnull
    public final IMPLTYPE executionDurationWarn(@Nullable Duration duration) {
        this.m_aExecutionDurationWarn = duration;
        return (IMPLTYPE)((AbstractRevocationCheckBuilder)this.thisAsT());
    }

    @Nonnull
    public final IMPLTYPE crlCache(@Nonnull CRLCache cRLCache) {
        ValueEnforcer.notNull((Object)cRLCache, (String)"CRLCache");
        this.m_aCRLCache = cRLCache;
        return (IMPLTYPE)((AbstractRevocationCheckBuilder)this.thisAsT());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public ERevoked build() {
        boolean bl;
        ERevocationCheckMode eRevocationCheckMode = this.m_eCheckMode != null ? this.m_eCheckMode : CertificateRevocationCheckerDefaults.getRevocationCheckMode();
        Consumer<? super GeneralSecurityException> consumer = this.m_aExceptionHdl != null ? this.m_aExceptionHdl : CertificateRevocationCheckerDefaults.getExceptionHdl();
        boolean bl2 = this.m_eAllowSoftFail.isDefined() ? this.m_eAllowSoftFail.getAsBooleanValue() : CertificateRevocationCheckerDefaults.isAllowSoftFail();
        Consumer<? super List<CertPathValidatorException>> consumer2 = this.m_aSoftFailExceptionHdl != null ? this.m_aSoftFailExceptionHdl : CertificateRevocationCheckerDefaults.getSoftFailExceptionHdl();
        boolean bl3 = bl = this.m_eExecuteInSynchronizedBlock.isDefined() ? this.m_eExecuteInSynchronizedBlock.getAsBooleanValue() : CertificateRevocationCheckerDefaults.isExecuteInSynchronizedBlock();
        if (this.m_aCert == null) {
            throw new IllegalStateException("The certificate to be checked must be set");
        }
        if (this.m_aValidCAs.isEmpty()) {
            throw new IllegalStateException("At least one valid CAs must be present");
        }
        if (this.m_aExecutionDurationWarn != null && this.m_aExecutionDurationWarn.toMillis() <= 0L) {
            throw new IllegalStateException("The duration for warning on long execution must be positive");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Performing certificate revocation check on certificate '" + this.m_aCert.getSubjectX500Principal().getName() + "' " + (String)(this.m_aCheckDate != null ? "for datetime " + String.valueOf(this.m_aCheckDate) : "without a datetime") + (bl ? " [synchronized]" : " [not synchronized]"));
        }
        StopWatch stopWatch = StopWatch.createdStarted();
        try {
            Object object;
            if (eRevocationCheckMode.isNone()) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Certificate revocation check is disabled");
                }
            } else {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Certificate revocation check is performed using mode " + String.valueOf((Object)eRevocationCheckMode) + "; executeSync=" + bl);
                }
                object = new X509CertSelector();
                ((X509CertSelector)object).setCertificate(this.m_aCert);
                CommonsHashSet commonsHashSet = new CommonsHashSet(this.m_aValidCAs, x509Certificate -> new TrustAnchor((X509Certificate)x509Certificate, null));
                PKIXBuilderParameters pKIXBuilderParameters = new PKIXBuilderParameters((Set<TrustAnchor>)commonsHashSet, (CertSelector)object);
                pKIXBuilderParameters.setRevocationEnabled(true);
                if (this.m_aCheckDate != null) {
                    pKIXBuilderParameters.setDate(this.m_aCheckDate);
                }
                IThrowingRunnable iThrowingRunnable = () -> {
                    List<CertPathValidatorException> list;
                    Object object;
                    Object object22;
                    PKIXRevocationChecker pKIXRevocationChecker;
                    ICommonsList<String> iCommonsList;
                    try {
                        boolean bl2 = eRevocationCheckMode.isOCSP();
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("Setting system property 'ocsp.enable' to " + bl2);
                        }
                        Security.setProperty("ocsp.enable", Boolean.toString(bl2));
                    }
                    catch (SecurityException securityException) {
                        LOGGER.warn("Failed to set Security property 'ocsp.enable' to '" + eRevocationCheckMode.isOCSP() + "'");
                    }
                    CertStore certStore = CertStore.getInstance("Collection", new CollectionCertStoreParameters((Collection<?>)this.m_aValidCAs));
                    pKIXBuilderParameters.addCertStore(certStore);
                    if (eRevocationCheckMode.isCRL()) {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("Setting up CRL check data");
                        }
                        iCommonsList = CRLHelper.getAllDistributionPoints(this.m_aCert);
                        pKIXRevocationChecker = new CommonsArrayList();
                        for (Object object22 : iCommonsList) {
                            object = this.m_aCRLCache.getCRLFromURL((String)object22);
                            if (object == null) continue;
                            pKIXRevocationChecker.add(object);
                        }
                        if (pKIXRevocationChecker.isNotEmpty()) {
                            pKIXBuilderParameters.addCertStore(CertStore.getInstance("Collection", new CollectionCertStoreParameters((Collection<?>)((Object)pKIXRevocationChecker))));
                        } else {
                            LOGGER.warn("Failed to find any CRL objects for revocation checking");
                        }
                    }
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Checking certificate\n" + String.valueOf(this.m_aCert) + "\n\nagainst " + this.m_aValidCAs.size() + " valid CAs:\n" + String.valueOf(this.m_aValidCAs));
                    }
                    iCommonsList = CertPathBuilder.getInstance("PKIX");
                    pKIXRevocationChecker = (PKIXRevocationChecker)iCommonsList.getRevocationChecker();
                    EnumSet<PKIXRevocationChecker.Option> enumSet = EnumSet.of(PKIXRevocationChecker.Option.ONLY_END_ENTITY);
                    if (bl2) {
                        enumSet.add(PKIXRevocationChecker.Option.SOFT_FAIL);
                    }
                    eRevocationCheckMode.addAllOptionsTo((Collection<? super PKIXRevocationChecker.Option>)enumSet);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("OCSP/CRL effective options = " + String.valueOf(enumSet));
                    }
                    pKIXRevocationChecker.setOptions((Set<PKIXRevocationChecker.Option>)enumSet);
                    object22 = (PKIXCertPathBuilderResult)iCommonsList.build((CertPathParameters)pKIXBuilderParameters);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("OCSP/CRL builder result = " + String.valueOf(object22));
                    }
                    object = ((PKIXCertPathBuilderResult)object22).getCertPath();
                    CertPathValidator certPathValidator = CertPathValidator.getInstance("PKIX");
                    PKIXCertPathValidatorResult pKIXCertPathValidatorResult = (PKIXCertPathValidatorResult)certPathValidator.validate((CertPath)object, pKIXBuilderParameters);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("OCSP/CRL validation result = " + String.valueOf(pKIXCertPathValidatorResult));
                    }
                    if (bl2 && !(list = pKIXRevocationChecker.getSoftFailExceptions()).isEmpty()) {
                        consumer2.accept(list);
                    }
                };
                if (bl) {
                    Class<CertificateRevocationCheckerDefaults> clazz = CertificateRevocationCheckerDefaults.class;
                    synchronized (CertificateRevocationCheckerDefaults.class) {
                        iThrowingRunnable.run();
                        // ** MonitorExit[var11_15] (shouldn't be in output)
                    }
                } else {
                    iThrowingRunnable.run();
                }
            }
            {
                object = ERevoked.NOT_REVOKED;
                return object;
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            LOGGER.error("Error running certification revocation check: " + generalSecurityException.getClass().getName() + " - " + generalSecurityException.getMessage());
            consumer.accept(generalSecurityException);
            ERevoked eRevoked = ERevoked.REVOKED;
            return eRevoked;
        }
        finally {
            long l = stopWatch.stopAndGetMillis();
            if (this.m_aExecutionDurationWarn != null && l > this.m_aExecutionDurationWarn.toMillis()) {
                LOGGER.warn("OCSP/CRL revocation check took " + l + " milliseconds which is too long");
            } else if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("OCSP/CRL revocation check took " + l + " milliseconds");
            }
        }
    }
}

