/*
 * Decompiled with CFR 0.152.
 */
package com.helger.security.keystore;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.builder.IBuilder;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.security.keystore.IKeyStoreDescriptor;
import com.helger.security.keystore.IKeyStoreType;
import com.helger.security.keystore.KeyStoreHelper;
import com.helger.security.keystore.LoadedKeyStore;
import java.security.Provider;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class KeyStoreDescriptor
implements IKeyStoreDescriptor {
    private final IKeyStoreType m_aType;
    private final String m_sPath;
    private final char[] m_aPassword;
    private final Provider m_aProvider;
    private LoadedKeyStore m_aLKS;

    public KeyStoreDescriptor(@Nonnull IKeyStoreType iKeyStoreType, @Nonnull @Nonempty String string, @Nonnull char[] cArray, @Nullable Provider provider) {
        ValueEnforcer.notNull((Object)iKeyStoreType, (String)"Type");
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Path");
        ValueEnforcer.notNull((Object)cArray, (String)"Password");
        this.m_aType = iKeyStoreType;
        this.m_sPath = string;
        this.m_aPassword = cArray;
        this.m_aProvider = provider;
    }

    @Override
    @Nonnull
    public final IKeyStoreType getKeyStoreType() {
        return this.m_aType;
    }

    @Override
    @Nonnull
    @Nonempty
    public final String getKeyStorePath() {
        return this.m_sPath;
    }

    @Override
    @Nonnull
    @ReturnsMutableObject
    public final char[] getKeyStorePassword() {
        return this.m_aPassword;
    }

    @Override
    @Nullable
    public final Provider getProvider() {
        return this.m_aProvider;
    }

    @Override
    @Nonnull
    public LoadedKeyStore loadKeyStore() {
        LoadedKeyStore loadedKeyStore = this.m_aLKS;
        if (loadedKeyStore == null) {
            loadedKeyStore = this.m_aLKS = KeyStoreHelper.loadKeyStore(this.m_aType, this.m_sPath, this.m_aPassword, this.m_aProvider);
        }
        return loadedKeyStore;
    }

    public String toString() {
        return new ToStringGenerator(null).append("Type", (Object)this.m_aType).append("Path", (Object)this.m_sPath).appendPassword("Password").appendIfNotNull("Provider", (Object)this.m_aProvider).getToString();
    }

    @Nonnull
    public static KeyStoreDescriptorBuilder builder() {
        return new KeyStoreDescriptorBuilder();
    }

    @Nonnull
    public static KeyStoreDescriptorBuilder builder(@Nonnull KeyStoreDescriptor keyStoreDescriptor) {
        return new KeyStoreDescriptorBuilder(keyStoreDescriptor);
    }

    public static class KeyStoreDescriptorBuilder
    implements IBuilder<KeyStoreDescriptor> {
        private IKeyStoreType m_aType;
        private String m_sPath;
        private char[] m_aPassword;
        private Provider m_aProvider;

        public KeyStoreDescriptorBuilder() {
        }

        public KeyStoreDescriptorBuilder(@Nonnull KeyStoreDescriptor keyStoreDescriptor) {
            this.type(keyStoreDescriptor.m_aType).path(keyStoreDescriptor.m_sPath).password(keyStoreDescriptor.m_aPassword).provider(keyStoreDescriptor.m_aProvider);
        }

        @Nonnull
        public final KeyStoreDescriptorBuilder type(@Nullable IKeyStoreType iKeyStoreType) {
            this.m_aType = iKeyStoreType;
            return this;
        }

        @Nonnull
        public final KeyStoreDescriptorBuilder path(@Nullable String string) {
            this.m_sPath = string;
            return this;
        }

        @Nonnull
        public final KeyStoreDescriptorBuilder password(@Nullable String string) {
            return this.password(string == null ? null : string.toCharArray());
        }

        @Nonnull
        public final KeyStoreDescriptorBuilder password(@Nullable char[] cArray) {
            this.m_aPassword = cArray;
            return this;
        }

        @Nonnull
        public final KeyStoreDescriptorBuilder provider(@Nullable Provider provider) {
            this.m_aProvider = provider;
            return this;
        }

        @Nonnull
        public KeyStoreDescriptor build() throws IllegalStateException {
            if (this.m_aType == null) {
                throw new IllegalStateException("Type is missing");
            }
            if (StringHelper.hasNoText((String)this.m_sPath)) {
                throw new IllegalStateException("Path is empty");
            }
            if (this.m_aPassword == null) {
                throw new IllegalStateException("Password is missing");
            }
            return new KeyStoreDescriptor(this.m_aType, this.m_sPath, this.m_aPassword, this.m_aProvider);
        }
    }
}

