/*
 * Decompiled with CFR 0.152.
 */
package com.helger.security.keystore;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.builder.IBuilder;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.security.keystore.IKeyStoreAndKeyDescriptor;
import com.helger.security.keystore.IKeyStoreType;
import com.helger.security.keystore.KeyStoreHelper;
import com.helger.security.keystore.LoadedKey;
import com.helger.security.keystore.LoadedKeyStore;
import java.security.KeyStore;
import java.security.Provider;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class KeyStoreAndKeyDescriptor
implements IKeyStoreAndKeyDescriptor {
    private final IKeyStoreType m_aType;
    private final String m_sPath;
    private final char[] m_aPassword;
    private final Provider m_aProvider;
    private final String m_sKeyAlias;
    private final char[] m_aKeyPassword;
    private LoadedKeyStore m_aLKS;
    private LoadedKey<KeyStore.PrivateKeyEntry> m_aLK;

    public KeyStoreAndKeyDescriptor(@Nonnull IKeyStoreType iKeyStoreType, @Nonnull @Nonempty String string, @Nonnull char[] cArray, @Nullable Provider provider, @Nonnull @Nonempty String string2, @Nonnull char[] cArray2) {
        ValueEnforcer.notNull((Object)iKeyStoreType, (String)"Type");
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Path");
        ValueEnforcer.notNull((Object)cArray, (String)"Password");
        ValueEnforcer.notEmpty((CharSequence)string2, (String)"KeyAlias");
        ValueEnforcer.notNull((Object)cArray2, (String)"KeyPassword");
        this.m_aType = iKeyStoreType;
        this.m_sPath = string;
        this.m_aPassword = cArray;
        this.m_aProvider = provider;
        this.m_sKeyAlias = string2;
        this.m_aKeyPassword = cArray2;
    }

    @Override
    @Nonnull
    public final IKeyStoreType getKeyStoreType() {
        return this.m_aType;
    }

    @Override
    @Nonnull
    @Nonempty
    public final String getKeyStorePath() {
        return this.m_sPath;
    }

    @Override
    @Nonnull
    @ReturnsMutableObject
    public final char[] getKeyStorePassword() {
        return this.m_aPassword;
    }

    @Override
    @Nullable
    public final Provider getProvider() {
        return this.m_aProvider;
    }

    @Override
    @Nonnull
    public LoadedKeyStore loadKeyStore() {
        LoadedKeyStore loadedKeyStore = this.m_aLKS;
        if (loadedKeyStore == null) {
            loadedKeyStore = this.m_aLKS = KeyStoreHelper.loadKeyStore(this.m_aType, this.m_sPath, this.m_aPassword, this.m_aProvider);
        }
        return loadedKeyStore;
    }

    @Override
    @Nonnull
    @Nonempty
    public final String getKeyAlias() {
        return this.m_sKeyAlias;
    }

    @Override
    @Nonnull
    @ReturnsMutableObject
    public final char[] getKeyPassword() {
        return this.m_aKeyPassword;
    }

    @Override
    @Nonnull
    public LoadedKey<KeyStore.PrivateKeyEntry> loadKey() {
        LoadedKey<KeyStore.PrivateKeyEntry> loadedKey = this.m_aLK;
        if (loadedKey == null) {
            loadedKey = this.m_aLK = KeyStoreHelper.loadPrivateKey(this.loadKeyStore().getKeyStore(), this.m_sPath, this.m_sKeyAlias, this.m_aKeyPassword);
        }
        return loadedKey;
    }

    public String toString() {
        return new ToStringGenerator(null).append("Type", (Object)this.m_aType).append("Path", (Object)this.m_sPath).appendPassword("Password").appendIfNotNull("Provider", (Object)this.m_aProvider).append("KeyAlias", (Object)this.m_sKeyAlias).appendPassword("KeyPassword").getToString();
    }

    @Nonnull
    public static KeyStoreAndKeyDescriptorBuilder builder() {
        return new KeyStoreAndKeyDescriptorBuilder();
    }

    @Nonnull
    public static KeyStoreAndKeyDescriptorBuilder builder(@Nonnull KeyStoreAndKeyDescriptor keyStoreAndKeyDescriptor) {
        return new KeyStoreAndKeyDescriptorBuilder(keyStoreAndKeyDescriptor);
    }

    public static class KeyStoreAndKeyDescriptorBuilder
    implements IBuilder<KeyStoreAndKeyDescriptor> {
        private IKeyStoreType m_aType;
        private String m_sPath;
        private char[] m_aPassword;
        private Provider m_aProvider;
        private String m_sKeyAlias;
        private char[] m_aKeyPassword;

        public KeyStoreAndKeyDescriptorBuilder() {
        }

        public KeyStoreAndKeyDescriptorBuilder(@Nonnull KeyStoreAndKeyDescriptor keyStoreAndKeyDescriptor) {
            this.type(keyStoreAndKeyDescriptor.m_aType).path(keyStoreAndKeyDescriptor.m_sPath).password(keyStoreAndKeyDescriptor.m_aPassword).provider(keyStoreAndKeyDescriptor.m_aProvider).keyAlias(keyStoreAndKeyDescriptor.m_sKeyAlias).keyPassword(keyStoreAndKeyDescriptor.m_aKeyPassword);
        }

        @Nonnull
        public final KeyStoreAndKeyDescriptorBuilder type(@Nullable IKeyStoreType iKeyStoreType) {
            this.m_aType = iKeyStoreType;
            return this;
        }

        @Nonnull
        public final KeyStoreAndKeyDescriptorBuilder path(@Nullable String string) {
            this.m_sPath = string;
            return this;
        }

        @Nonnull
        public final KeyStoreAndKeyDescriptorBuilder password(@Nullable String string) {
            return this.password(string == null ? null : string.toCharArray());
        }

        @Nonnull
        public final KeyStoreAndKeyDescriptorBuilder password(@Nullable char[] cArray) {
            this.m_aPassword = cArray;
            return this;
        }

        @Nonnull
        public final KeyStoreAndKeyDescriptorBuilder provider(@Nullable Provider provider) {
            this.m_aProvider = provider;
            return this;
        }

        @Nonnull
        public final KeyStoreAndKeyDescriptorBuilder keyAlias(@Nullable String string) {
            this.m_sKeyAlias = string;
            return this;
        }

        @Nonnull
        public final KeyStoreAndKeyDescriptorBuilder keyPassword(@Nullable String string) {
            return this.keyPassword(string == null ? null : string.toCharArray());
        }

        @Nonnull
        public final KeyStoreAndKeyDescriptorBuilder keyPassword(@Nullable char[] cArray) {
            this.m_aKeyPassword = cArray;
            return this;
        }

        @Nonnull
        public KeyStoreAndKeyDescriptor build() throws IllegalStateException {
            if (this.m_aType == null) {
                throw new IllegalStateException("Type is missing");
            }
            if (StringHelper.hasNoText((String)this.m_sPath)) {
                throw new IllegalStateException("Path is empty");
            }
            if (this.m_aPassword == null) {
                throw new IllegalStateException("Password is missing");
            }
            if (StringHelper.hasNoText((String)this.m_sKeyAlias)) {
                throw new IllegalStateException("KeyAlias is empty");
            }
            if (this.m_aKeyPassword == null) {
                throw new IllegalStateException("KeyPassword is missing");
            }
            return new KeyStoreAndKeyDescriptor(this.m_aType, this.m_sPath, this.m_aPassword, this.m_aProvider, this.m_sKeyAlias, this.m_aKeyPassword);
        }
    }
}

