/*
 * Decompiled with CFR 0.152.
 */
package com.helger.security.authentication.result;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.state.ESuccess;
import com.helger.commons.string.StringHelper;
import com.helger.security.authentication.result.AuthToken;
import com.helger.security.authentication.result.IAuthIdentification;
import com.helger.security.authentication.result.IAuthToken;
import com.helger.security.authentication.subject.IAuthSubject;
import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class AuthTokenRegistry {
    private static final SimpleReadWriteLock RW_LOCK = new SimpleReadWriteLock();
    private static final ICommonsMap<String, AuthToken> MAP = new CommonsHashMap();

    private AuthTokenRegistry() {
    }

    @Nonnull
    public static IAuthToken createToken(@Nonnull IAuthIdentification iAuthIdentification, @Nonnegative int n) {
        AuthToken authToken = new AuthToken(iAuthIdentification, n);
        String string = authToken.getID();
        RW_LOCK.writeLocked(() -> {
            if (MAP.containsKey((Object)string)) {
                throw new IllegalArgumentException("Token '" + string + "' already contained");
            }
            MAP.put((Object)string, (Object)authToken);
        });
        return authToken;
    }

    @Nonnull
    public static ESuccess removeToken(@Nonnull String string) {
        return (ESuccess)RW_LOCK.writeLockedGet(() -> {
            AuthToken authToken = (AuthToken)MAP.remove((Object)string);
            if (authToken == null) {
                return ESuccess.FAILURE;
            }
            authToken.setExpired();
            return ESuccess.SUCCESS;
        });
    }

    @Nullable
    private static AuthToken _getValidNotExpiredToken(@Nullable String string) {
        if (StringHelper.hasNoText((String)string)) {
            return null;
        }
        AuthToken authToken = (AuthToken)RW_LOCK.readLockedGet(() -> (AuthToken)MAP.get((Object)string));
        return authToken != null && !authToken.isExpired() ? authToken : null;
    }

    @Nullable
    public static IAuthToken getValidToken(@Nullable String string) {
        return AuthTokenRegistry._getValidNotExpiredToken(string);
    }

    @Nullable
    public static IAuthToken validateTokenAndUpdateLastAccess(@Nullable String string) {
        AuthToken authToken = AuthTokenRegistry._getValidNotExpiredToken(string);
        if (authToken == null) {
            return null;
        }
        RW_LOCK.writeLocked(authToken::updateLastAccess);
        return authToken;
    }

    @Nonnull
    public static ICommonsList<IAuthToken> getAllTokensOfSubject(@Nonnull IAuthSubject iAuthSubject) {
        ValueEnforcer.notNull((Object)iAuthSubject, (String)"Subject");
        return (ICommonsList)RW_LOCK.readLockedGet(() -> CommonsArrayList.createFiltered((Iterable)MAP.values(), iAuthToken -> iAuthToken.getIdentification().hasAuthSubject(iAuthSubject)));
    }

    @Nonnegative
    public static int removeAllTokensOfSubject(@Nonnull IAuthSubject iAuthSubject) {
        ValueEnforcer.notNull((Object)iAuthSubject, (String)"Subject");
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        RW_LOCK.readLocked(() -> AuthTokenRegistry.lambda$removeAllTokensOfSubject$5(iAuthSubject, (ICommonsList)commonsArrayList));
        for (String string : commonsArrayList) {
            AuthTokenRegistry.removeToken(string);
        }
        return commonsArrayList.size();
    }

    private static /* synthetic */ void lambda$removeAllTokensOfSubject$5(IAuthSubject iAuthSubject, ICommonsList iCommonsList) {
        for (Map.Entry entry : MAP.entrySet()) {
            if (!((AuthToken)entry.getValue()).getIdentification().hasAuthSubject(iAuthSubject)) continue;
            iCommonsList.add((Object)((String)entry.getKey()));
        }
    }
}

