/*
 * Decompiled with CFR 0.152.
 */
package com.helger.scope;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.lang.ClassHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.scope.AbstractScope;
import com.helger.scope.IRequestScope;
import com.helger.scope.ScopeHelper;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestScope
extends AbstractScope
implements IRequestScope {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestScope.class);
    private final String m_sSessionID;

    public RequestScope(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2) {
        super(string);
        this.m_sSessionID = (String)ValueEnforcer.notEmpty((CharSequence)string2, (String)"SessionID");
        if (ScopeHelper.isDebugRequestScopeLifeCycle(LOGGER) && LOGGER.isInfoEnabled()) {
            LOGGER.info("Created request scope '" + string + "'", ScopeHelper.getDebugStackTrace());
        }
    }

    @Override
    @Nonnull
    @Nonempty
    public final String getSessionID(boolean bl) {
        return this.m_sSessionID;
    }

    @Override
    public void initScope() {
    }

    @Override
    protected void preDestroy() {
        if (ScopeHelper.isDebugRequestScopeLifeCycle(LOGGER) && LOGGER.isInfoEnabled()) {
            LOGGER.info("Destroying request scope '" + this.getID() + "' of class " + ClassHelper.getClassLocalName((Object)this), ScopeHelper.getDebugStackTrace());
        }
    }

    @Override
    protected void postDestroy() {
        if (ScopeHelper.isDebugRequestScopeLifeCycle(LOGGER) && LOGGER.isInfoEnabled()) {
            LOGGER.info("Destroyed request scope '" + this.getID() + "' of class " + ClassHelper.getClassLocalName((Object)this), ScopeHelper.getDebugStackTrace());
        }
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("sessionID", (Object)this.m_sSessionID).getToString();
    }
}

