/*
 * Decompiled with CFR 0.152.
 */
package com.helger.json;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.state.EChange;
import com.helger.base.string.StringHelper;
import com.helger.base.trait.IGenericAdderTrait;
import com.helger.base.trait.ITypeConverterTo;
import com.helger.collection.base.FilterIterator;
import com.helger.collection.base.IIterableIterator;
import com.helger.collection.base.MapperIterator;
import com.helger.collection.commons.ICommonsIterable;
import com.helger.collection.commons.ICommonsList;
import com.helger.json.IJson;
import com.helger.json.IJsonCollection;
import com.helger.json.IJsonObject;
import com.helger.json.IJsonValue;
import com.helger.json.JsonValue;
import com.helger.json.TypeConverterToIJson;
import com.helger.typeconvert.trait.IGetterByIndexTrait;
import java.util.function.ObjIntConsumer;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public interface IJsonArray
extends IJsonCollection,
ICommonsIterable<IJson>,
IGetterByIndexTrait,
IGenericAdderTrait<IJson, IJsonArray> {
    default public @NonNull ITypeConverterTo<IJson> getTypeConverterTo() {
        return TypeConverterToIJson.INSTANCE;
    }

    @Nonnegative
    public int size();

    default public @NonNull IJsonArray addIfNotEmpty(@Nullable String string) {
        if (StringHelper.isNotEmpty((String)string)) {
            this.add(string);
        }
        return (IJsonArray)this.thisAsT();
    }

    public @Nullable IJson removeAndReturnAtIndex(@Nonnegative int var1);

    public @NonNull EChange removeAtIndex(@Nonnegative int var1);

    public @Nullable IJson get(@Nonnegative int var1);

    default public @Nullable IJsonValue getValueAtIndex(@Nonnegative int n) {
        IJson iJson = this.get(n);
        return iJson != null && iJson.isValue() ? (IJsonValue)iJson : null;
    }

    default public @Nullable IJsonArray getArrayAtIndex(@Nonnegative int n) {
        IJson iJson = this.get(n);
        return iJson != null && iJson.isArray() ? (IJsonArray)iJson : null;
    }

    default public @Nullable IJsonObject getObjectAtIndex(@Nonnegative int n) {
        IJson iJson = this.get(n);
        return iJson != null && iJson.isObject() ? (IJsonObject)iJson : null;
    }

    default public @Nullable Object getValue(@Nonnegative int n) {
        IJson iJson = this.get(n);
        return iJson != null && iJson.isValue() ? iJson.getAsValue().getValue() : null;
    }

    @ReturnsMutableCopy
    public @NonNull IJsonArray getSubArray(@Nonnegative int var1, @Nonnegative int var2);

    @ReturnsMutableCopy
    public @NonNull ICommonsList<IJson> getAll();

    public void forEachByIndex(@NonNull ObjIntConsumer<? super IJson> var1);

    public boolean contains(@Nullable IJson var1);

    default public boolean contains(@Nullable Object object) {
        return this.contains(JsonValue.create(object));
    }

    default public boolean contains(boolean bl) {
        return this.contains(JsonValue.create(bl));
    }

    default public boolean contains(char c) {
        return this.contains(JsonValue.create(c));
    }

    default public boolean contains(double d) {
        return this.contains(JsonValue.create(d));
    }

    default public boolean contains(int n) {
        return this.contains(JsonValue.create(n));
    }

    default public boolean contains(long l) {
        return this.contains(JsonValue.create(l));
    }

    default public @NonNull IIterableIterator<IJsonArray> iteratorArrays() {
        return new MapperIterator((IIterableIterator)new FilterIterator((Iterable)((Object)this), IJson::isArray), IJson::getAsArray);
    }

    default public @NonNull IIterableIterator<IJsonObject> iteratorObjects() {
        return new MapperIterator((IIterableIterator)new FilterIterator((Iterable)((Object)this), IJson::isObject), IJson::getAsObject);
    }

    default public @NonNull IIterableIterator<IJsonValue> iteratorValues() {
        return new MapperIterator((IIterableIterator)new FilterIterator((Iterable)((Object)this), IJson::isValue), IJson::getAsValue);
    }

    @ReturnsMutableCopy
    public @NonNull ICommonsList<IJson> getClonedValues();

    public @NonNull IJsonArray getClone();
}

