/*
 * Decompiled with CFR 0.152.
 */
package com.helger.json.valueserializer;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.json.valueserializer.IJsonValueSerializer;
import java.io.IOException;
import java.io.Writer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillNotClose;

public final class JsonValueSerializerConstant
implements IJsonValueSerializer {
    public static final JsonValueSerializerConstant TRUE = new JsonValueSerializerConstant("true");
    public static final JsonValueSerializerConstant FALSE = new JsonValueSerializerConstant("false");
    public static final JsonValueSerializerConstant NULL = new JsonValueSerializerConstant("null");
    private final String m_sValue;

    public JsonValueSerializerConstant(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Value");
        this.m_sValue = string;
    }

    @Nonnull
    @Nonempty
    public String getValue() {
        return this.m_sValue;
    }

    @Override
    public void appendAsJsonString(@Nullable Object object, @Nonnull @WillNotClose Writer writer) throws IOException {
        writer.write(this.m_sValue);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        JsonValueSerializerConstant jsonValueSerializerConstant = (JsonValueSerializerConstant)object;
        return this.m_sValue.equals(jsonValueSerializerConstant.m_sValue);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sValue).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("value", (Object)this.m_sValue).getToString();
    }
}

