/*
 * Decompiled with CFR 0.152.
 */
package com.helger.http.header.specific;

import com.helger.annotation.concurrent.Immutable;
import com.helger.base.string.StringHelper;
import com.helger.base.string.StringParser;
import com.helger.http.header.specific.AcceptMimeTypeList;
import com.helger.mime.EMimeContentType;
import com.helger.mime.IMimeType;
import com.helger.mime.MimeType;
import com.helger.mime.parse.MimeTypeParser;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class AcceptMimeTypeHandler {
    public static final IMimeType ANY_MIMETYPE = new MimeType(EMimeContentType._STAR, "*");
    private static final Logger LOGGER = LoggerFactory.getLogger(AcceptMimeTypeHandler.class);
    private static final AcceptMimeTypeHandler INSTANCE = new AcceptMimeTypeHandler();

    private AcceptMimeTypeHandler() {
    }

    public static @NonNull AcceptMimeTypeList getAcceptMimeTypes(@Nullable String string) {
        AcceptMimeTypeList acceptMimeTypeList = new AcceptMimeTypeList();
        if (StringHelper.isEmpty((String)string)) {
            acceptMimeTypeList.addMimeType(ANY_MIMETYPE, 1.0);
        } else {
            for (String string2 : StringHelper.getExploded((char)',', (String)string)) {
                String string3;
                MimeType mimeType;
                String[] stringArray = StringHelper.getExplodedArray((char)';', (String)string2.trim(), (int)2);
                double d = 1.0;
                if (stringArray.length == 2 && stringArray[1].trim().startsWith("q=")) {
                    d = StringParser.parseDouble((String)stringArray[1].trim().substring(2), (double)1.0);
                }
                if ((mimeType = MimeTypeParser.safeParseMimeType((String)(string3 = stringArray[0]))) != null) {
                    if (mimeType.hasAnyParameters()) {
                        LOGGER.warn("Ignoring all contained MIME type parameter from '" + string3 + "'!");
                        mimeType = mimeType.getCopyWithoutParameters();
                    }
                    acceptMimeTypeList.addMimeType((IMimeType)mimeType, d);
                    continue;
                }
                if ("*".equals(string3)) {
                    acceptMimeTypeList.addMimeType(ANY_MIMETYPE, d);
                    continue;
                }
                if ("xml/xml".equals(string3)) continue;
                LOGGER.warn("Failed to parse Mime type '" + string3 + "' as part of '" + string + "'!");
            }
        }
        return acceptMimeTypeList;
    }
}

