/*
 * Decompiled with CFR 0.152.
 */
package com.helger.http.header;

import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsLinkedHashMap;
import com.helger.collection.commons.ICommonsOrderedMap;
import com.helger.http.header.QValue;
import java.util.Map;
import java.util.function.Function;
import org.jspecify.annotations.NonNull;

public abstract class AbstractQValueList<KEYTYPE> {
    private final ICommonsOrderedMap<KEYTYPE, QValue> m_aMap = new CommonsLinkedHashMap();

    @ReturnsMutableCopy
    protected final @NonNull ICommonsOrderedMap<KEYTYPE, QValue> qvalueMap() {
        return this.m_aMap;
    }

    @ReturnsMutableCopy
    public final @NonNull ICommonsOrderedMap<KEYTYPE, QValue> getAllQValues() {
        return this.m_aMap.getClone();
    }

    @ReturnsMutableCopy
    public final @NonNull ICommonsOrderedMap<KEYTYPE, QValue> getAllQValuesLowerThan(double d) {
        CommonsLinkedHashMap commonsLinkedHashMap = new CommonsLinkedHashMap();
        for (Map.Entry entry : this.m_aMap.entrySet()) {
            QValue qValue = (QValue)entry.getValue();
            if (!(qValue.getQuality() < d)) continue;
            commonsLinkedHashMap.put(entry.getKey(), (Object)qValue);
        }
        return commonsLinkedHashMap;
    }

    @ReturnsMutableCopy
    public final @NonNull ICommonsOrderedMap<KEYTYPE, QValue> getAllQValuesLowerOrEqual(double d) {
        CommonsLinkedHashMap commonsLinkedHashMap = new CommonsLinkedHashMap();
        for (Map.Entry entry : this.m_aMap.entrySet()) {
            QValue qValue = (QValue)entry.getValue();
            if (!(qValue.getQuality() <= d)) continue;
            commonsLinkedHashMap.put(entry.getKey(), (Object)qValue);
        }
        return commonsLinkedHashMap;
    }

    @ReturnsMutableCopy
    public final @NonNull ICommonsOrderedMap<KEYTYPE, QValue> getAllQValuesGreaterThan(double d) {
        CommonsLinkedHashMap commonsLinkedHashMap = new CommonsLinkedHashMap();
        for (Map.Entry entry : this.m_aMap.entrySet()) {
            QValue qValue = (QValue)entry.getValue();
            if (!(qValue.getQuality() > d)) continue;
            commonsLinkedHashMap.put(entry.getKey(), (Object)qValue);
        }
        return commonsLinkedHashMap;
    }

    @ReturnsMutableCopy
    public final @NonNull ICommonsOrderedMap<KEYTYPE, QValue> getAllQValuesGreaterOrEqual(double d) {
        CommonsLinkedHashMap commonsLinkedHashMap = new CommonsLinkedHashMap();
        for (Map.Entry entry : this.m_aMap.entrySet()) {
            QValue qValue = (QValue)entry.getValue();
            if (!(qValue.getQuality() >= d)) continue;
            commonsLinkedHashMap.put(entry.getKey(), (Object)qValue);
        }
        return commonsLinkedHashMap;
    }

    public abstract @NonNull String getAsHttpHeaderValue();

    protected @NonNull String getAsHttpHeaderValue(@NonNull Function<KEYTYPE, String> function) {
        return AbstractQValueList.getAsHttpHeaderValue(this.m_aMap, function);
    }

    public static <T> @NonNull String getAsHttpHeaderValue(@NonNull ICommonsOrderedMap<T, QValue> iCommonsOrderedMap, @NonNull Function<T, String> function) {
        ValueEnforcer.notNull(iCommonsOrderedMap, (String)"Map");
        ValueEnforcer.notNull(function, (String)"KeyTransformer");
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry entry : iCommonsOrderedMap.entrySet()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(function.apply(entry.getKey())).append("; q=").append(((QValue)entry.getValue()).getQuality());
        }
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        AbstractQValueList abstractQValueList = (AbstractQValueList)object;
        return this.m_aMap.equals(abstractQValueList.m_aMap);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aMap).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("map", this.m_aMap).getToString();
    }
}

