/*
 * Decompiled with CFR 0.152.
 */
package com.helger.graph.impl;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.state.EChange;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.CollectionFind;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.CommonsHashSet;
import com.helger.collection.commons.CommonsLinkedHashMap;
import com.helger.collection.commons.CommonsLinkedHashSet;
import com.helger.collection.commons.ICommonsList;
import com.helger.collection.commons.ICommonsOrderedMap;
import com.helger.collection.commons.ICommonsOrderedSet;
import com.helger.collection.commons.ICommonsSet;
import com.helger.graph.IDirectedGraphRelation;
import com.helger.graph.IMutableDirectedGraphNode;
import com.helger.graph.IMutableDirectedGraphRelation;
import com.helger.graph.impl.AbstractBaseGraphObject;
import java.util.Collection;
import java.util.function.Consumer;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@NotThreadSafe
public class DirectedGraphNode
extends AbstractBaseGraphObject
implements IMutableDirectedGraphNode {
    private ICommonsOrderedMap<String, IMutableDirectedGraphRelation> m_aIncoming;
    private ICommonsOrderedMap<String, IMutableDirectedGraphRelation> m_aOutgoing;

    public DirectedGraphNode() {
        this(null);
    }

    public DirectedGraphNode(@Nullable String string) {
        super(string);
    }

    @Override
    public final boolean isDirected() {
        return true;
    }

    @Override
    public void addIncomingRelation(@NonNull IMutableDirectedGraphRelation iMutableDirectedGraphRelation) {
        ValueEnforcer.notNull((Object)iMutableDirectedGraphRelation, (String)"NewRelation");
        ValueEnforcer.isTrue((iMutableDirectedGraphRelation.getTo() == this ? 1 : 0) != 0, (String)"Passed incoming relation is not based on this node");
        if (this.m_aIncoming != null) {
            if (this.m_aIncoming.containsKey(iMutableDirectedGraphRelation.getID())) {
                throw new IllegalArgumentException("The passed relation (" + String.valueOf(iMutableDirectedGraphRelation) + ") is already contained as an incoming relation");
            }
            for (IMutableDirectedGraphRelation iMutableDirectedGraphRelation2 : this.m_aIncoming.values()) {
                if (iMutableDirectedGraphRelation2.getFrom() != iMutableDirectedGraphRelation.getFrom()) continue;
                throw new IllegalArgumentException("The from-node of the passed relation (" + String.valueOf(iMutableDirectedGraphRelation) + ") is already contained");
            }
        } else {
            this.m_aIncoming = new CommonsLinkedHashMap();
        }
        this.m_aIncoming.put((Object)((String)iMutableDirectedGraphRelation.getID()), (Object)iMutableDirectedGraphRelation);
    }

    @Override
    public boolean hasIncomingRelations() {
        return this.m_aIncoming != null && this.m_aIncoming.isNotEmpty();
    }

    @Override
    @Nonnegative
    public int getIncomingRelationCount() {
        return this.m_aIncoming == null ? 0 : this.m_aIncoming.size();
    }

    @Override
    public boolean isIncomingRelation(@Nullable IMutableDirectedGraphRelation iMutableDirectedGraphRelation) {
        return this.m_aIncoming != null && iMutableDirectedGraphRelation != null && iMutableDirectedGraphRelation.equals(this.m_aIncoming.get(iMutableDirectedGraphRelation.getID()));
    }

    @Override
    @ReturnsMutableCopy
    public @NonNull ICommonsList<IMutableDirectedGraphRelation> getAllIncomingRelations() {
        return this.m_aIncoming == null ? new CommonsArrayList() : new CommonsArrayList(this.m_aIncoming.values());
    }

    @Override
    public void forEachIncomingRelation(@NonNull Consumer<? super IMutableDirectedGraphRelation> consumer) {
        ValueEnforcer.notNull(consumer, (String)"Consumer");
        if (this.m_aIncoming != null) {
            this.m_aIncoming.forEachValue(consumer);
        }
    }

    @Override
    public @NonNull EChange removeIncomingRelation(@Nullable IMutableDirectedGraphRelation iMutableDirectedGraphRelation) {
        return iMutableDirectedGraphRelation == null || this.m_aIncoming == null ? EChange.UNCHANGED : this.m_aIncoming.removeObject((Object)((String)iMutableDirectedGraphRelation.getID()));
    }

    @Override
    public @NonNull EChange removeAllIncomingRelations() {
        if (!this.hasIncomingRelations()) {
            return EChange.UNCHANGED;
        }
        this.m_aIncoming = null;
        return EChange.CHANGED;
    }

    @Override
    public boolean isFromNode(@Nullable IMutableDirectedGraphNode iMutableDirectedGraphNode) {
        return this.getIncomingRelationFrom(iMutableDirectedGraphNode) != null;
    }

    @Override
    @ReturnsMutableCopy
    public @NonNull ICommonsSet<IMutableDirectedGraphNode> getAllFromNodes() {
        CommonsHashSet commonsHashSet = new CommonsHashSet();
        if (this.m_aIncoming != null) {
            CollectionFind.findAllMapped((Iterable)this.m_aIncoming.values(), IDirectedGraphRelation::getFrom, arg_0 -> ((ICommonsSet)commonsHashSet).add(arg_0));
        }
        return commonsHashSet;
    }

    @Override
    public @Nullable IMutableDirectedGraphRelation getIncomingRelationFrom(@Nullable IMutableDirectedGraphNode iMutableDirectedGraphNode) {
        if (this.m_aIncoming != null && iMutableDirectedGraphNode != null) {
            for (IMutableDirectedGraphRelation iMutableDirectedGraphRelation : this.m_aIncoming.values()) {
                if (!((IMutableDirectedGraphNode)iMutableDirectedGraphRelation.getFrom()).equals(iMutableDirectedGraphNode)) continue;
                return iMutableDirectedGraphRelation;
            }
        }
        return null;
    }

    @Override
    public void addOutgoingRelation(@NonNull IMutableDirectedGraphRelation iMutableDirectedGraphRelation) {
        ValueEnforcer.notNull((Object)iMutableDirectedGraphRelation, (String)"NewRelation");
        ValueEnforcer.isTrue((iMutableDirectedGraphRelation.getFrom() == this ? 1 : 0) != 0, (String)"Passed outgoing relation is not based on this node");
        if (this.m_aOutgoing != null) {
            if (this.m_aOutgoing.containsKey(iMutableDirectedGraphRelation.getID())) {
                throw new IllegalArgumentException("The passed relation " + String.valueOf(iMutableDirectedGraphRelation) + " is already contained as an outgoing relation");
            }
            for (IMutableDirectedGraphRelation iMutableDirectedGraphRelation2 : this.m_aOutgoing.values()) {
                if (iMutableDirectedGraphRelation2.getTo() != iMutableDirectedGraphRelation.getTo()) continue;
                throw new IllegalArgumentException("The to-node of the passed relation " + String.valueOf(iMutableDirectedGraphRelation) + " is already contained");
            }
        } else {
            this.m_aOutgoing = new CommonsLinkedHashMap();
        }
        this.m_aOutgoing.put((Object)((String)iMutableDirectedGraphRelation.getID()), (Object)iMutableDirectedGraphRelation);
    }

    @Override
    public boolean hasOutgoingRelations() {
        return this.m_aOutgoing != null && this.m_aOutgoing.isNotEmpty();
    }

    @Override
    @Nonnegative
    public int getOutgoingRelationCount() {
        return this.m_aOutgoing == null ? 0 : this.m_aOutgoing.size();
    }

    @Override
    public boolean isOutgoingRelation(@Nullable IMutableDirectedGraphRelation iMutableDirectedGraphRelation) {
        return this.m_aOutgoing != null && iMutableDirectedGraphRelation != null && iMutableDirectedGraphRelation.equals(this.m_aOutgoing.get(iMutableDirectedGraphRelation.getID()));
    }

    @Override
    @ReturnsMutableCopy
    public @NonNull ICommonsList<IMutableDirectedGraphRelation> getAllOutgoingRelations() {
        return this.m_aOutgoing == null ? new CommonsArrayList() : new CommonsArrayList(this.m_aOutgoing.values());
    }

    @Override
    public void forEachOutgoingRelation(@NonNull Consumer<? super IMutableDirectedGraphRelation> consumer) {
        ValueEnforcer.notNull(consumer, (String)"Consumer");
        if (this.m_aOutgoing != null) {
            this.m_aOutgoing.values().forEach(consumer);
        }
    }

    @Override
    @ReturnsMutableCopy
    public @NonNull ICommonsSet<IMutableDirectedGraphNode> getAllToNodes() {
        CommonsHashSet commonsHashSet = new CommonsHashSet();
        if (this.m_aOutgoing != null) {
            CollectionFind.findAllMapped((Iterable)this.m_aOutgoing.values(), IDirectedGraphRelation::getTo, arg_0 -> ((ICommonsSet)commonsHashSet).add(arg_0));
        }
        return commonsHashSet;
    }

    @Override
    public @NonNull EChange removeOutgoingRelation(@Nullable IMutableDirectedGraphRelation iMutableDirectedGraphRelation) {
        return iMutableDirectedGraphRelation == null || this.m_aOutgoing == null ? EChange.UNCHANGED : this.m_aOutgoing.removeObject((Object)((String)iMutableDirectedGraphRelation.getID()));
    }

    @Override
    public @NonNull EChange removeAllOutgoingRelations() {
        if (!this.hasOutgoingRelations()) {
            return EChange.UNCHANGED;
        }
        this.m_aOutgoing = null;
        return EChange.CHANGED;
    }

    @Override
    public boolean isToNode(@Nullable IMutableDirectedGraphNode iMutableDirectedGraphNode) {
        return this.getOutgoingRelationTo(iMutableDirectedGraphNode) != null;
    }

    @Override
    public @Nullable IMutableDirectedGraphRelation getOutgoingRelationTo(@Nullable IMutableDirectedGraphNode iMutableDirectedGraphNode) {
        if (this.m_aOutgoing != null && iMutableDirectedGraphNode != null) {
            for (IMutableDirectedGraphRelation iMutableDirectedGraphRelation : this.m_aOutgoing.values()) {
                if (!((IMutableDirectedGraphNode)iMutableDirectedGraphRelation.getTo()).equals(iMutableDirectedGraphNode)) continue;
                return iMutableDirectedGraphRelation;
            }
        }
        return null;
    }

    @Override
    public boolean isConnectedWith(@Nullable IMutableDirectedGraphNode iMutableDirectedGraphNode) {
        if (iMutableDirectedGraphNode == null) {
            return false;
        }
        return this.getIncomingRelationFrom(iMutableDirectedGraphNode) != null || this.getOutgoingRelationTo(iMutableDirectedGraphNode) != null;
    }

    @Override
    public @Nullable IMutableDirectedGraphRelation getRelation(@Nullable IMutableDirectedGraphNode iMutableDirectedGraphNode) {
        if (iMutableDirectedGraphNode == null) {
            return null;
        }
        IMutableDirectedGraphRelation iMutableDirectedGraphRelation = this.getIncomingRelationFrom(iMutableDirectedGraphNode);
        IMutableDirectedGraphRelation iMutableDirectedGraphRelation2 = this.getOutgoingRelationTo(iMutableDirectedGraphNode);
        if (iMutableDirectedGraphRelation != null && iMutableDirectedGraphRelation2 != null) {
            throw new IllegalStateException("Both incoming and outgoing relations between node '" + this.getID() + "' and '" + (String)iMutableDirectedGraphNode.getID() + "' exist!");
        }
        return iMutableDirectedGraphRelation != null ? iMutableDirectedGraphRelation : iMutableDirectedGraphRelation2;
    }

    @Override
    @ReturnsMutableCopy
    public @NonNull ICommonsOrderedSet<IMutableDirectedGraphRelation> getAllRelations() {
        CommonsLinkedHashSet commonsLinkedHashSet = new CommonsLinkedHashSet();
        if (this.m_aIncoming != null) {
            commonsLinkedHashSet.addAll(this.m_aIncoming.values());
        }
        if (this.m_aOutgoing != null) {
            commonsLinkedHashSet.addAll(this.m_aOutgoing.values());
        }
        return commonsLinkedHashSet;
    }

    @Override
    @ReturnsMutableCopy
    public @NonNull ICommonsOrderedSet<String> getAllRelationIDs() {
        CommonsLinkedHashSet commonsLinkedHashSet = new CommonsLinkedHashSet();
        if (this.m_aIncoming != null) {
            commonsLinkedHashSet.addAll((Collection)this.m_aIncoming.keySet());
        }
        if (this.m_aOutgoing != null) {
            commonsLinkedHashSet.addAll((Collection)this.m_aOutgoing.keySet());
        }
        return commonsLinkedHashSet;
    }

    @Override
    @ReturnsMutableCopy
    public @NonNull ICommonsOrderedSet<IMutableDirectedGraphNode> getAllRelatedNodes() {
        CommonsLinkedHashSet commonsLinkedHashSet = new CommonsLinkedHashSet();
        if (this.m_aIncoming != null) {
            for (IMutableDirectedGraphRelation iMutableDirectedGraphRelation : this.m_aIncoming.values()) {
                commonsLinkedHashSet.add((Object)((IMutableDirectedGraphNode)iMutableDirectedGraphRelation.getFrom()));
            }
        }
        if (this.m_aOutgoing != null) {
            for (IMutableDirectedGraphRelation iMutableDirectedGraphRelation : this.m_aOutgoing.values()) {
                commonsLinkedHashSet.add((Object)((IMutableDirectedGraphNode)iMutableDirectedGraphRelation.getTo()));
            }
        }
        return commonsLinkedHashSet;
    }

    @Override
    @ReturnsMutableCopy
    public @NonNull ICommonsOrderedSet<String> getAllRelatedNodeIDs() {
        CommonsLinkedHashSet commonsLinkedHashSet = new CommonsLinkedHashSet();
        if (this.m_aIncoming != null) {
            for (IMutableDirectedGraphRelation iMutableDirectedGraphRelation : this.m_aIncoming.values()) {
                commonsLinkedHashSet.add((Object)iMutableDirectedGraphRelation.getFromID());
            }
        }
        if (this.m_aOutgoing != null) {
            for (IMutableDirectedGraphRelation iMutableDirectedGraphRelation : this.m_aOutgoing.values()) {
                commonsLinkedHashSet.add((Object)iMutableDirectedGraphRelation.getToID());
            }
        }
        return commonsLinkedHashSet;
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("incomingIDs", this.m_aIncoming == null ? null : this.m_aIncoming.keySet()).append("outgoingIDs", this.m_aOutgoing == null ? null : this.m_aOutgoing.keySet()).getToString();
    }
}

