/*
 * Decompiled with CFR 0.152.
 */
package com.helger.graph.algo;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.CommonsLinkedHashMap;
import com.helger.commons.collection.impl.CommonsLinkedHashSet;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsOrderedMap;
import com.helger.commons.debug.GlobalDebug;
import com.helger.commons.lang.GenericReflection;
import com.helger.graph.IMutableBaseGraph;
import com.helger.graph.IMutableBaseGraphNode;
import com.helger.graph.IMutableBaseGraphRelation;
import com.helger.graph.IMutableDirectedGraphNode;
import com.helger.graph.IMutableDirectedGraphRelation;
import java.util.function.ToIntFunction;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Dijkstra {
    private static final Logger LOGGER = LoggerFactory.getLogger(Dijkstra.class);

    private Dijkstra() {
    }

    @Nullable
    private static <N extends IMutableBaseGraphNode<N, R>, R extends IMutableBaseGraphRelation<N, R>> R _getRelationFromLastMatch(@Nonnull WorkElement<N> workElement, @Nonnull N n) {
        if (n.isDirected()) {
            N n2 = workElement.getToNode();
            N n3 = n;
            IMutableDirectedGraphRelation iMutableDirectedGraphRelation = (IMutableDirectedGraphRelation)((IMutableDirectedGraphNode)n2).getOutgoingRelationTo((IMutableDirectedGraphNode)n3);
            return (R)((IMutableBaseGraphRelation)GenericReflection.uncheckedCast((Object)iMutableDirectedGraphRelation));
        }
        return (R)((IMutableBaseGraphRelation)workElement.getToNode().getRelation(n));
    }

    @Nonnull
    public static <N extends IMutableBaseGraphNode<N, R>, R extends IMutableBaseGraphRelation<N, R>> Result<N> applyDijkstra(@Nonnull IMutableBaseGraph<N, R> iMutableBaseGraph, @Nonnull @Nonempty String string, @Nonnull @Nonempty String string2, @Nonnull ToIntFunction<? super R> toIntFunction) {
        int n;
        Object object;
        block14: {
            IMutableBaseGraphNode iMutableBaseGraphNode = (IMutableBaseGraphNode)iMutableBaseGraph.getNodeOfID(string);
            if (iMutableBaseGraphNode == null) {
                throw new IllegalArgumentException("Invalid From ID: " + string);
            }
            IMutableBaseGraphNode iMutableBaseGraphNode2 = (IMutableBaseGraphNode)iMutableBaseGraph.getNodeOfID(string2);
            if (iMutableBaseGraphNode2 == null) {
                throw new IllegalArgumentException("Invalid To ID: " + string2);
            }
            CommonsLinkedHashSet commonsLinkedHashSet = new CommonsLinkedHashSet(iMutableBaseGraph.getAllNodes().values());
            if (GlobalDebug.isDebugMode()) {
                LOGGER.info("Starting Dijkstra on directed graph with " + commonsLinkedHashSet.size() + " nodes starting from '" + string + "' and up to '" + string2 + "'");
            }
            CommonsLinkedHashMap commonsLinkedHashMap = new CommonsLinkedHashMap();
            Object object2 = null;
            WorkRow<Object> workRow = null;
            int n2 = 0;
            do {
                WorkRow<Object> workRow2 = new WorkRow<Object>(commonsLinkedHashSet.size());
                if (workRow == null) {
                    for (Object object3 : commonsLinkedHashSet) {
                        if (object3.equals(iMutableBaseGraphNode)) {
                            workRow2.add(new WorkElement<IMutableBaseGraphNode>(0, (IMutableBaseGraphNode)object3));
                            continue;
                        }
                        workRow2.add(new WorkElement<IMutableBaseGraphNode>(Integer.MAX_VALUE, (IMutableBaseGraphNode)object3));
                    }
                } else {
                    for (Object object3 : commonsLinkedHashSet) {
                        WorkElement workElement = workRow.getElement((String)object3.getID());
                        Object object4 = Dijkstra._getRelationFromLastMatch(object2, object3);
                        if (object4 != null) {
                            int n3 = ((WorkElement)object2).getDistance() + toIntFunction.applyAsInt(object4);
                            if (n3 < workElement.getDistance()) {
                                workRow2.add(new WorkElement<Object>(((WorkElement)object2).getToNode(), n3, object3));
                                continue;
                            }
                            workRow2.add(workElement);
                            continue;
                        }
                        workRow2.add(workElement);
                    }
                }
                object = workRow2.getClosestElement();
                if (GlobalDebug.isDebugMode()) {
                    Object object3;
                    object3 = new StringBuilder("Iteration[").append(n2).append("]: ");
                    for (Object object4 : workRow2.getAllElements()) {
                        ((StringBuilder)object3).append(((WorkElement)object4).getAsString());
                    }
                    ((StringBuilder)object3).append(" ==> ").append(((WorkElement)object).getAsString());
                    LOGGER.info(((StringBuilder)object3).toString());
                }
                commonsLinkedHashSet.remove(((WorkElement)object).getToNode());
                commonsLinkedHashMap.put((Object)((WorkElement)object).getToNodeID(), object);
                object2 = object;
                workRow = workRow2;
                ++n2;
            } while (!((WorkElement)object).getToNode().equals(iMutableBaseGraphNode2));
            n = ((WorkElement)object2).getDistance();
            object = new CommonsArrayList();
            do {
                object.add(0, ((WorkElement)object2).getToNode());
                if (((WorkElement)object2).getFromNode() == null) break block14;
            } while ((object2 = (WorkElement)commonsLinkedHashMap.get((Object)((WorkElement)object2).getFromNodeID())) != null);
            throw new IllegalStateException("Inconsistency!");
        }
        return new Result(object, n);
    }

    private static final class WorkElement<N extends IMutableBaseGraphNode<N, ?>> {
        private final N m_aFromNode;
        private final int m_nDistance;
        private final N m_aToNode;

        public WorkElement(@Nonnegative int n, @Nonnull N n2) {
            this(null, n, n2);
        }

        public WorkElement(@Nullable N n, @Nonnegative int n2, @Nonnull N n3) {
            ValueEnforcer.isGE0((int)n2, (String)"Distance");
            ValueEnforcer.notNull(n3, (String)"ToNode");
            this.m_aFromNode = n;
            this.m_nDistance = n2;
            this.m_aToNode = n3;
        }

        @Nullable
        public N getFromNode() {
            return this.m_aFromNode;
        }

        @Nullable
        public String getFromNodeID() {
            return this.m_aFromNode == null ? null : (String)this.m_aFromNode.getID();
        }

        @Nonnegative
        public int getDistance() {
            return this.m_nDistance;
        }

        @Nonnull
        public N getToNode() {
            return this.m_aToNode;
        }

        @Nonnull
        public String getToNodeID() {
            return (String)this.m_aToNode.getID();
        }

        @Nonnull
        @Nonempty
        public String getAsString() {
            return "{" + (String)(this.m_aFromNode == null ? "" : "'" + (String)this.m_aFromNode.getID() + "',") + (this.m_nDistance == Integer.MAX_VALUE ? "Inf" : Integer.toString(this.m_nDistance)) + ",'" + (String)this.m_aToNode.getID() + "'}";
        }
    }

    private static final class WorkRow<N extends IMutableBaseGraphNode<N, ?>> {
        private final ICommonsOrderedMap<String, WorkElement<N>> m_aElements;

        public WorkRow(@Nonnegative int n) {
            ValueEnforcer.isGT0((int)n, (String)"Elements");
            this.m_aElements = new CommonsLinkedHashMap(n);
        }

        public void add(@Nonnull WorkElement<N> workElement) {
            ValueEnforcer.notNull(workElement, (String)"Element");
            this.m_aElements.put((Object)workElement.getToNodeID(), workElement);
        }

        @Nullable
        public WorkElement<N> getElement(@Nullable String string) {
            return (WorkElement)this.m_aElements.get((Object)string);
        }

        @Nonnull
        public WorkElement<N> getClosestElement() {
            WorkElement workElement = null;
            for (WorkElement workElement2 : this.m_aElements.values()) {
                if (workElement != null && workElement2.getDistance() >= workElement.getDistance()) continue;
                workElement = workElement2;
            }
            if (workElement == null) {
                throw new IllegalStateException("Cannot call this method without an element!");
            }
            return workElement;
        }

        @Nonnull
        @ReturnsMutableCopy
        public ICommonsList<WorkElement<N>> getAllElements() {
            return this.m_aElements.copyOfValues();
        }
    }

    @Immutable
    public static final class Result<N extends IMutableBaseGraphNode<N, ?>> {
        private final ICommonsList<N> m_aResultNodes;
        private final int m_nResultDistance;

        public Result(@Nonnull @Nonempty ICommonsList<N> iCommonsList, @Nonnegative int n) {
            ValueEnforcer.notEmpty(iCommonsList, (String)"EesultNodes");
            ValueEnforcer.isGE0((int)n, (String)"Result Distance");
            this.m_aResultNodes = iCommonsList;
            this.m_nResultDistance = n;
        }

        @Nonnull
        @ReturnsMutableCopy
        public ICommonsList<N> getAllResultNodes() {
            return (ICommonsList)this.m_aResultNodes.getClone();
        }

        @Nonnegative
        public int getResultNodeCount() {
            return this.m_aResultNodes.size();
        }

        @Nonnegative
        public int getResultDistance() {
            return this.m_nResultDistance;
        }

        @Nonnull
        @Nonempty
        public String getAsString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Distance ").append(this.m_nResultDistance).append(" for route {");
            int n = 0;
            for (IMutableBaseGraphNode iMutableBaseGraphNode : this.m_aResultNodes) {
                if (n > 0) {
                    stringBuilder.append(',');
                }
                stringBuilder.append('\'').append((String)iMutableBaseGraphNode.getID()).append('\'');
                ++n;
            }
            return stringBuilder.append('}').toString();
        }
    }
}

