/*
 * Decompiled with CFR 0.152.
 */
package com.helger.graph.iterate;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.NonBlockingStack;
import com.helger.commons.collection.impl.CommonsHashSet;
import com.helger.commons.collection.impl.ICommonsSet;
import com.helger.commons.collection.iterate.IIterableIterator;
import com.helger.graph.IMutableDirectedGraphNode;
import com.helger.graph.IMutableDirectedGraphRelation;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class DirectedGraphIteratorForward
implements IIterableIterator<IMutableDirectedGraphNode> {
    private final NonBlockingStack<IterationNode> m_aNodeStack = new NonBlockingStack();
    private final Predicate<? super IMutableDirectedGraphRelation> m_aRelationFilter;
    private final ICommonsSet<String> m_aHandledNodes = new CommonsHashSet();
    private boolean m_bHasCycles = false;

    public DirectedGraphIteratorForward(@Nonnull IMutableDirectedGraphNode iMutableDirectedGraphNode) {
        this(iMutableDirectedGraphNode, null);
    }

    public DirectedGraphIteratorForward(@Nonnull IMutableDirectedGraphNode iMutableDirectedGraphNode, @Nullable Predicate<? super IMutableDirectedGraphRelation> predicate) {
        ValueEnforcer.notNull((Object)iMutableDirectedGraphNode, (String)"StartNode");
        this.m_aRelationFilter = predicate;
        this.m_aNodeStack.push((Object)new IterationNode(iMutableDirectedGraphNode));
    }

    public boolean hasNext() {
        return !this.m_aNodeStack.isEmpty();
    }

    @Nullable
    public IMutableDirectedGraphNode next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        IMutableDirectedGraphNode iMutableDirectedGraphNode = ((IterationNode)this.m_aNodeStack.peek()).getNode();
        this.m_aHandledNodes.add((Object)((String)iMutableDirectedGraphNode.getID()));
        boolean bl = false;
        while (!this.m_aNodeStack.isEmpty() && !bl) {
            Iterator<IMutableDirectedGraphRelation> iterator = ((IterationNode)this.m_aNodeStack.peek()).getOutgoingRelationIterator();
            while (iterator.hasNext()) {
                IMutableDirectedGraphRelation iMutableDirectedGraphRelation = iterator.next();
                if (this.m_aRelationFilter != null && !this.m_aRelationFilter.test(iMutableDirectedGraphRelation)) continue;
                IMutableDirectedGraphNode iMutableDirectedGraphNode2 = (IMutableDirectedGraphNode)iMutableDirectedGraphRelation.getTo();
                for (IterationNode iterationNode : this.m_aNodeStack) {
                    if (iterationNode.getNode() != iMutableDirectedGraphNode2) continue;
                    this.m_bHasCycles = true;
                    break;
                }
                if (this.m_aHandledNodes.contains(iMutableDirectedGraphNode2.getID())) continue;
                this.m_aNodeStack.push((Object)new IterationNode(iMutableDirectedGraphNode2));
                bl = true;
                break;
            }
            if (bl) continue;
            this.m_aNodeStack.pop();
        }
        return iMutableDirectedGraphNode;
    }

    public boolean hasCycles() {
        return this.m_bHasCycles;
    }

    private static final class IterationNode {
        private final IMutableDirectedGraphNode m_aNode;
        private final Iterator<IMutableDirectedGraphRelation> m_aOutgoingIt;

        private IterationNode(@Nonnull IMutableDirectedGraphNode iMutableDirectedGraphNode) {
            this.m_aNode = (IMutableDirectedGraphNode)ValueEnforcer.notNull((Object)iMutableDirectedGraphNode, (String)"Node");
            this.m_aOutgoingIt = iMutableDirectedGraphNode.getAllOutgoingRelations().iterator();
        }

        @Nonnull
        public IMutableDirectedGraphNode getNode() {
            return this.m_aNode;
        }

        @Nonnull
        public Iterator<IMutableDirectedGraphRelation> getOutgoingRelationIterator() {
            return this.m_aOutgoingIt;
        }
    }
}

