/*
 * Decompiled with CFR 0.152.
 */
package com.helger.graph.algo;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.collection.impl.CommonsTreeSet;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.debug.GlobalDebug;
import com.helger.commons.string.StringHelper;
import com.helger.graph.IMutableGraphNode;
import com.helger.graph.IMutableGraphRelation;
import com.helger.graph.simple.ISimpleGraph;
import com.helger.graph.simple.SimpleGraph;
import com.helger.graph.simple.SimpleGraphObjectFastFactory;
import java.util.Comparator;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Kruskal {
    private static final Logger LOGGER = LoggerFactory.getLogger(Kruskal.class);
    private static final Kruskal INSTANCE = new Kruskal();

    private Kruskal() {
    }

    private static String _getWeightInfo(@Nonnull IMutableGraphRelation iMutableGraphRelation, @Nonnull @Nonempty String string) {
        return "{" + StringHelper.getImploded((char)',', (Iterable)new CommonsTreeSet(iMutableGraphRelation.getAllConnectedNodeIDs())) + ":" + iMutableGraphRelation.attrs().getAsInt((Object)string) + "}";
    }

    @Nonnull
    public static Result applyKruskal(@Nonnull ISimpleGraph iSimpleGraph, @Nonnull @Nonempty String string) {
        ICommonsList iCommonsList = iSimpleGraph.getAllRelationObjs().getSortedInline(Comparator.comparingInt(iMutableGraphRelation -> iMutableGraphRelation.attrs().getAsInt((Object)string)));
        if (GlobalDebug.isDebugMode()) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Starting Kruskal on " + iCommonsList.size() + " relations");
            }
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Sorted relations: " + StringHelper.getImplodedMapped((char)';', (Iterable)iCommonsList, iMutableGraphRelation -> Kruskal._getWeightInfo(iMutableGraphRelation, string)));
            }
        }
        SimpleGraph simpleGraph = new SimpleGraph(new SimpleGraphObjectFastFactory());
        for (IMutableGraphNode iMutableGraphNode : iSimpleGraph.getAllNodes().values()) {
            IMutableGraphNode iMutableGraphNode2 = simpleGraph.createNode((String)iMutableGraphNode.getID());
            iMutableGraphNode2.attrs().putAllIn(iMutableGraphNode.attrs());
        }
        int n = iSimpleGraph.getNodeCount() - 1;
        int n2 = 0;
        for (IMutableGraphRelation iMutableGraphRelation2 : iCommonsList) {
            int n3 = iMutableGraphRelation2.attrs().getAsInt((Object)string);
            IMutableGraphRelation iMutableGraphRelation3 = simpleGraph.createRelation(iMutableGraphRelation2.getNode1ID(), iMutableGraphRelation2.getNode2ID());
            iMutableGraphRelation3.attrs().putAllIn(iMutableGraphRelation2.attrs());
            if (simpleGraph.containsCycles()) {
                if (GlobalDebug.isDebugMode() && LOGGER.isInfoEnabled()) {
                    LOGGER.info("Ignoring " + Kruskal._getWeightInfo(iMutableGraphRelation3, string) + " because it introduces a cycle!");
                }
                simpleGraph.removeRelation(iMutableGraphRelation3);
                continue;
            }
            if (GlobalDebug.isDebugMode() && LOGGER.isInfoEnabled()) {
                LOGGER.info("Added " + Kruskal._getWeightInfo(iMutableGraphRelation3, string) + "!");
            }
            n2 += n3;
            if (--n != 0) continue;
            break;
        }
        if (GlobalDebug.isDebugMode() && LOGGER.isInfoEnabled()) {
            LOGGER.info("Having a total weight of " + n2);
        }
        return new Result(simpleGraph, n2);
    }

    public static final class Result {
        private final SimpleGraph m_aGraph;
        private final int m_nTotalWeight;

        public Result(@Nonnull SimpleGraph simpleGraph, int n) {
            ValueEnforcer.notNull((Object)simpleGraph, (String)"Graph");
            this.m_aGraph = simpleGraph;
            this.m_nTotalWeight = n;
        }

        @Nonnull
        public SimpleGraph getGraph() {
            return this.m_aGraph;
        }

        public int getTotalWeight() {
            return this.m_nTotalWeight;
        }

        @Nonnull
        @Nonempty
        public String getAsString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Total weight ").append(this.m_nTotalWeight).append(" for nodes {");
            int n = 0;
            for (IMutableGraphNode iMutableGraphNode : this.m_aGraph.getAllNodes().values()) {
                if (n > 0) {
                    stringBuilder.append(',');
                }
                stringBuilder.append('\'').append((String)iMutableGraphNode.getID()).append('\'');
                ++n;
            }
            return stringBuilder.append('}').toString();
        }
    }
}

