/*
 * Decompiled with CFR 0.152.
 */
package com.helger.diagnostics.error.level;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.base.lang.EnumHelper;
import com.helger.diagnostics.error.level.IErrorLevel;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public enum EErrorLevel implements IErrorLevel
{
    SUCCESS("success", 0),
    INFO("info", 100),
    WARN("warn", 200),
    ERROR("error", 300),
    FATAL_ERROR("fatal_error", 400);

    public static final EErrorLevel LOWEST;
    public static final EErrorLevel HIGHEST;
    private final String m_sID;
    private final int m_nNumericLevel;

    private EErrorLevel(String string2, int n2) {
        this.m_sID = string2;
        this.m_nNumericLevel = n2;
    }

    public @NonNull @Nonempty String getID() {
        return this.m_sID;
    }

    @Override
    @Nonnegative
    public int getNumericLevel() {
        return this.m_nNumericLevel;
    }

    public static @Nullable EErrorLevel getFromIDOrNull(@Nullable String string) {
        return (EErrorLevel)EnumHelper.getFromIDOrNull(EErrorLevel.class, (Object)string);
    }

    public static @NonNull EErrorLevel getFromIDOrThrow(@Nullable String string) {
        return (EErrorLevel)EnumHelper.getFromIDOrThrow(EErrorLevel.class, (Object)string);
    }

    public static @Nullable EErrorLevel getFromIDOrDefault(@Nullable String string, @Nullable EErrorLevel eErrorLevel) {
        return (EErrorLevel)EnumHelper.getFromIDOrDefault(EErrorLevel.class, (Object)string, (Enum)eErrorLevel);
    }

    public static @Nullable EErrorLevel getFromIDCaseInsensitiveOrNull(@Nullable String string) {
        return (EErrorLevel)EnumHelper.getFromIDCaseInsensitiveOrNull(EErrorLevel.class, (String)string);
    }

    public static @NonNull EErrorLevel getFromIDCaseInsensitiveOrThrow(@Nullable String string) {
        return (EErrorLevel)EnumHelper.getFromIDCaseInsensitiveOrThrow(EErrorLevel.class, (String)string);
    }

    public static @Nullable EErrorLevel getFromIDCaseInsensitiveOrDefault(@Nullable String string, @Nullable EErrorLevel eErrorLevel) {
        return (EErrorLevel)EnumHelper.getFromIDCaseInsensitiveOrDefault(EErrorLevel.class, (String)string, (Enum)eErrorLevel);
    }

    static {
        LOWEST = SUCCESS;
        HIGHEST = FATAL_ERROR;
    }
}

