/*
 * Decompiled with CFR 0.152.
 */
package com.helger.datetime.domain;

import com.helger.base.enforce.ValueEnforcer;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@FunctionalInterface
public interface IHasTrashDateTime {
    public @Nullable LocalDateTime getTrashDateTime();

    default public boolean hasTrashDateTime() {
        return this.getTrashDateTime() != null;
    }

    default public @Nullable LocalDate getTrashDate() {
        LocalDateTime localDateTime = this.getTrashDateTime();
        return localDateTime == null ? null : localDateTime.toLocalDate();
    }

    default public @Nullable LocalTime getTrashTime() {
        LocalDateTime localDateTime = this.getTrashDateTime();
        return localDateTime == null ? null : localDateTime.toLocalTime();
    }

    default public boolean isTrashedAt(@NonNull LocalDateTime localDateTime) {
        ValueEnforcer.notNull((Object)localDateTime, (String)"LocalDateTime");
        return this.hasTrashDateTime() && this.getTrashDateTime().compareTo(localDateTime) <= 0;
    }
}

