/*
 * Decompiled with CFR 0.152.
 */
package com.helger.datetime.domain;

import com.helger.base.enforce.ValueEnforcer;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@FunctionalInterface
public interface IHasCreationDateTime {
    public @Nullable LocalDateTime getCreationDateTime();

    default public boolean hasCreationDateTime() {
        return this.getCreationDateTime() != null;
    }

    default public @Nullable LocalDate getCreationDate() {
        LocalDateTime localDateTime = this.getCreationDateTime();
        return localDateTime == null ? null : localDateTime.toLocalDate();
    }

    default public @Nullable LocalTime getCreationTime() {
        LocalDateTime localDateTime = this.getCreationDateTime();
        return localDateTime == null ? null : localDateTime.toLocalTime();
    }

    default public boolean isCreatedAt(@NonNull LocalDateTime localDateTime) {
        ValueEnforcer.notNull((Object)localDateTime, (String)"LocalDateTime");
        return this.hasCreationDateTime() && this.getCreationDateTime().compareTo(localDateTime) <= 0;
    }
}

