/*
 * Decompiled with CFR 0.152.
 */
package com.helger.datetime.expiration;

import com.helger.commons.datetime.PDTFactory;
import java.time.Duration;
import java.time.LocalDateTime;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface IExpirable {
    @Nullable
    public LocalDateTime getExpirationDateTime();

    default public boolean isExpirationDefined() {
        return this.getExpirationDateTime() != null;
    }

    default public boolean isExpiredNow() {
        return this.isExpiredAt(PDTFactory.getCurrentLocalDateTime());
    }

    default public boolean isExpiredAt(@Nonnull LocalDateTime localDateTime) {
        return this.isExpirationDefined() && localDateTime.isAfter(this.getExpirationDateTime());
    }

    default public boolean isExpiredIn(@Nonnull Duration duration) {
        return this.isExpiredAt(PDTFactory.getCurrentLocalDateTime().plus(duration));
    }
}

