/*
 * Decompiled with CFR 0.152.
 */
package com.helger.csv;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.WillCloseWhenClosed;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.io.nonblocking.NonBlockingBufferedReader;
import com.helger.base.io.stream.StreamHelper;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsIterable;
import com.helger.collection.commons.ICommonsList;
import com.helger.csv.CSVIterator;
import com.helger.csv.CSVLineReaderKeepCR;
import com.helger.csv.CSVLineReaderNonBlockingBufferedReader;
import com.helger.csv.CSVParser;
import com.helger.csv.ICSVLineReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.util.Iterator;
import java.util.function.Consumer;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class CSVReader
implements Closeable,
ICommonsIterable<ICommonsList<String>> {
    private final Reader m_aReader;
    private final ICSVLineReader m_aLineReader;
    private final CSVParser m_aParser;
    private int m_nSkipLines = 0;
    private final boolean m_bKeepCR;
    private boolean m_bVerifyReader = true;
    private boolean m_bHasNext = true;
    private boolean m_bLinesSkiped = false;

    public CSVReader(@WillCloseWhenClosed @NonNull Reader reader) {
        this(reader, new CSVParser(), false);
    }

    public CSVReader(@WillCloseWhenClosed @NonNull Reader reader, boolean bl) {
        this(reader, new CSVParser(), bl);
    }

    public CSVReader(@WillCloseWhenClosed @NonNull Reader reader, @NonNull CSVParser cSVParser, boolean bl) {
        ValueEnforcer.notNull((Object)reader, (String)"Reader");
        ValueEnforcer.notNull((Object)cSVParser, (String)"Parser");
        Reader reader2 = StreamHelper.getBuffered((Reader)reader);
        if (bl) {
            this.m_aLineReader = new CSVLineReaderKeepCR(reader2);
        } else {
            if (!(reader2 instanceof NonBlockingBufferedReader)) {
                reader2 = new NonBlockingBufferedReader(reader2);
            }
            this.m_aLineReader = new CSVLineReaderNonBlockingBufferedReader((NonBlockingBufferedReader)reader2);
        }
        this.m_aReader = reader2;
        this.m_aParser = cSVParser;
        this.m_bKeepCR = bl;
    }

    public @NonNull CSVParser getParser() {
        return this.m_aParser;
    }

    public char getSeparatorChar() {
        return this.m_aParser.getSeparatorChar();
    }

    public @NonNull CSVReader setSeparatorChar(char c) {
        this.m_aParser.setSeparatorChar(c);
        return this;
    }

    public char getQuoteChar() {
        return this.m_aParser.getQuoteChar();
    }

    public @NonNull CSVReader setQuoteChar(char c) {
        this.m_aParser.setQuoteChar(c);
        return this;
    }

    public char getEscapeChar() {
        return this.m_aParser.getEscapeChar();
    }

    public @NonNull CSVReader setEscapeChar(char c) {
        this.m_aParser.setEscapeChar(c);
        return this;
    }

    public boolean isStrictQuotes() {
        return this.m_aParser.isStrictQuotes();
    }

    public @NonNull CSVReader setStrictQuotes(boolean bl) {
        this.m_aParser.setStrictQuotes(bl);
        return this;
    }

    public boolean isIgnoreLeadingWhiteSpace() {
        return this.m_aParser.isIgnoreLeadingWhiteSpace();
    }

    public @NonNull CSVReader setIgnoreLeadingWhiteSpace(boolean bl) {
        this.m_aParser.setIgnoreLeadingWhiteSpace(bl);
        return this;
    }

    public boolean isIgnoreQuotations() {
        return this.m_aParser.isIgnoreQuotations();
    }

    public @NonNull CSVReader setIgnoreQuotations(boolean bl) {
        this.m_aParser.setIgnoreQuotations(bl);
        return this;
    }

    @Nonnegative
    public int getSkipLines() {
        return this.m_nSkipLines;
    }

    public @NonNull CSVReader setSkipLines(@Nonnegative int n) {
        ValueEnforcer.isGE0((int)n, (String)"SkipLines");
        this.m_nSkipLines = n;
        return this;
    }

    public boolean isKeepCarriageReturns() {
        return this.m_bKeepCR;
    }

    public boolean isVerifyReader() {
        return this.m_bVerifyReader;
    }

    public @NonNull CSVReader setVerifyReader(boolean bl) {
        this.m_bVerifyReader = bl;
        return this;
    }

    @ReturnsMutableCopy
    public @NonNull ICommonsList<ICommonsList<String>> readAll() throws IOException {
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        while (this.m_bHasNext) {
            ICommonsList<String> iCommonsList = this.readNext();
            if (iCommonsList == null) continue;
            commonsArrayList.add(iCommonsList);
        }
        return commonsArrayList;
    }

    public void readAll(@NonNull Consumer<? super ICommonsList<String>> consumer) throws IOException {
        while (this.m_bHasNext) {
            ICommonsList<String> iCommonsList = this.readNext();
            if (iCommonsList == null) continue;
            consumer.accept((ICommonsList<String>)iCommonsList);
        }
    }

    public @Nullable ICommonsList<String> readNext() throws IOException {
        ICommonsList<String> iCommonsList = null;
        do {
            String string = this._getNextLine();
            if (!this.m_bHasNext) {
                return iCommonsList;
            }
            ICommonsList<String> iCommonsList2 = this.m_aParser.parseLineMulti(string);
            if (iCommonsList == null) {
                iCommonsList = iCommonsList2;
                continue;
            }
            iCommonsList.addAll(iCommonsList2);
        } while (this.m_aParser.isPending());
        return iCommonsList;
    }

    private @Nullable String _getNextLine() throws IOException {
        if (this._isClosed()) {
            this.m_bHasNext = false;
            return null;
        }
        if (!this.m_bLinesSkiped) {
            for (int i = 0; i < this.m_nSkipLines; ++i) {
                this.m_aLineReader.readLine();
            }
            this.m_bLinesSkiped = true;
        }
        if (!this.m_bHasNext) {
            return null;
        }
        String string = this.m_aLineReader.readLine();
        if (string == null) {
            this.m_bHasNext = false;
        }
        return string;
    }

    private boolean _isClosed() {
        if (!this.m_bVerifyReader) {
            return false;
        }
        try {
            return !this.m_aReader.ready();
        }
        catch (IOException iOException) {
            return true;
        }
    }

    @Override
    public void close() throws IOException {
        this.m_aReader.close();
    }

    public @NonNull Iterator<ICommonsList<String>> iterator() {
        try {
            return new CSVIterator(this);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException("Error creating CSVIterator", iOException);
        }
    }
}

