/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.serialize.convert;

import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.IsSPIImplementation;
import com.helger.base.charset.CharsetHelper;
import com.helger.base.io.stream.StreamHelper;
import com.helger.commons.serialize.convert.ISerializationConverter;
import com.helger.commons.serialize.convert.ISerializationConverterRegistrarSPI;
import com.helger.commons.serialize.convert.ISerializationConverterRegistry;
import jakarta.annotation.Nonnull;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.charset.Charset;
import javax.imageio.ImageIO;

@IsSPIImplementation
@Immutable
public final class BasicSerializationConverterRegistrar
implements ISerializationConverterRegistrarSPI {
    @Override
    public void registerSerializationConverter(@Nonnull ISerializationConverterRegistry iSerializationConverterRegistry) {
        iSerializationConverterRegistry.registerSerializationConverter(BufferedImage.class, new SerializationConverterBufferedImage());
        iSerializationConverterRegistry.registerSerializationConverter(Charset.class, new SerializationConverterCharset());
    }

    private static final class SerializationConverterBufferedImage
    implements ISerializationConverter<BufferedImage> {
        private SerializationConverterBufferedImage() {
        }

        @Override
        public void writeConvertedObject(@Nonnull BufferedImage bufferedImage, @Nonnull ObjectOutputStream objectOutputStream) throws IOException {
            ImageIO.write((RenderedImage)bufferedImage, "png", objectOutputStream);
        }

        @Override
        public BufferedImage readConvertedObject(@Nonnull ObjectInputStream objectInputStream) throws IOException {
            return ImageIO.read(objectInputStream);
        }
    }

    private static final class SerializationConverterCharset
    implements ISerializationConverter<Charset> {
        private SerializationConverterCharset() {
        }

        @Override
        public void writeConvertedObject(@Nonnull Charset charset, @Nonnull ObjectOutputStream objectOutputStream) throws IOException {
            StreamHelper.writeSafeUTF((DataOutput)objectOutputStream, (String)charset.name());
        }

        @Override
        public Charset readConvertedObject(@Nonnull ObjectInputStream objectInputStream) throws IOException {
            String string = StreamHelper.readSafeUTF((DataInput)objectInputStream);
            return CharsetHelper.getCharsetFromName((String)string);
        }
    }
}

