/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.system;

import com.helger.commons.annotation.DevelopersNote;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsCopyOnWriteArraySet;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.CommonsHashSet;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.collection.impl.ICommonsSet;
import com.helger.commons.lang.PropertiesHelper;
import com.helger.commons.lang.priviledged.IPrivilegedAction;
import com.helger.commons.log.ConditionalLogger;
import com.helger.commons.log.IHasConditionalLogger;
import com.helger.commons.state.EChange;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class SystemProperties
implements IHasConditionalLogger {
    public static final String SYSTEM_PROPERTY_FILE_SEPARATOR = "file.separator";
    public static final String SYSTEM_PROPERTY_JAVA_CLASS_PATH = "java.class.path";
    public static final String SYSTEM_PROPERTY_JAVA_CLASS_VERSION = "java.class.version";
    public static final String SYSTEM_PROPERTY_JAVA_LIBRARY_PATH = "java.library.path";
    public static final String SYSTEM_PROPERTY_JAVA_HOME = "java.home";
    public static final String SYSTEM_PROPERTY_JAVA_IO_TMPDIR = "java.io.tmpdir";
    public static final String SYSTEM_PROPERTY_JAVA_RUNTIME_NAME = "java.runtime.name";
    public static final String SYSTEM_PROPERTY_JAVA_RUNTIME_VERSION = "java.runtime.version";
    public static final String SYSTEM_PROPERTY_JAVA_SPECIFICATION_URL = "java.specification.url";
    public static final String SYSTEM_PROPERTY_JAVA_SPECIFICATION_VENDOR = "java.specification.vendor";
    public static final String SYSTEM_PROPERTY_JAVA_SPECIFICATION_VERSION = "java.specification.version";
    public static final String SYSTEM_PROPERTY_JAVA_VENDOR = "java.vendor";
    public static final String SYSTEM_PROPERTY_JAVA_VENDOR_URL = "java.vendor.url";
    public static final String SYSTEM_PROPERTY_JAVA_VERSION = "java.version";
    public static final String SYSTEM_PROPERTY_JAVA_VM_NAME = "java.vm.name";
    public static final String SYSTEM_PROPERTY_JAVA_VM_SPECIFICATION_URL = "java.vm.specification.url";
    public static final String SYSTEM_PROPERTY_JAVA_VM_SPECIFICATION_VENDOR = "java.vm.specification.vendor";
    public static final String SYSTEM_PROPERTY_JAVA_VM_SPECIFICATION_VERSION = "java.vm.specification.version";
    public static final String SYSTEM_PROPERTY_JAVA_VM_URL = "java.vm.url";
    public static final String SYSTEM_PROPERTY_JAVA_VM_VENDOR = "java.vm.vendor";
    public static final String SYSTEM_PROPERTY_JAVA_VM_VERSION = "java.vm.version";
    public static final String SYSTEM_PROPERTY_LINE_SEPARATOR = "line.separator";
    public static final String SYSTEM_PROPERTY_OS_ARCH = "os.arch";
    public static final String SYSTEM_PROPERTY_OS_NAME = "os.name";
    public static final String SYSTEM_PROPERTY_OS_VERSION = "os.version";
    public static final String SYSTEM_PROPERTY_PATH_SEPARATOR = "path.separator";
    public static final String SYSTEM_PROPERTY_USER_DIR = "user.dir";
    public static final String SYSTEM_PROPERTY_USER_HOME = "user.home";
    public static final String SYSTEM_PROPERTY_USER_NAME = "user.name";
    public static final String SYSTEM_PROPERTY_SUN_IO_SERIALIZATION_EXTENDEDDEBUGINFO = "sun.io.serialization.extendedDebugInfo";
    private static final Logger LOGGER = LoggerFactory.getLogger(SystemProperties.class);
    private static final ConditionalLogger CONDLOG = new ConditionalLogger(LOGGER, false);
    private static final ICommonsSet<String> WARNED_PROP_NAMES = new CommonsCopyOnWriteArraySet<String>();
    private static final SystemProperties INSTANCE = new SystemProperties();

    private SystemProperties() {
    }

    public static boolean isSilentMode() {
        return CONDLOG.isDisabled();
    }

    public static boolean setSilentMode(boolean bl) {
        return !CONDLOG.setEnabled(!bl);
    }

    @Nullable
    public static String getPropertyValueOrNull(@Nullable String string) {
        return string == null ? null : IPrivilegedAction.systemGetProperty(string).invokeSafe();
    }

    @Nullable
    public static String getPropertyValue(@Nullable String string) {
        String string2 = null;
        if (string != null && (string2 = SystemProperties.getPropertyValueOrNull(string)) == null && WARNED_PROP_NAMES.add(string)) {
            CONDLOG.warn(() -> "System property '" + string + "' cannot be read because it is not set");
        }
        return string2;
    }

    public static void clearWarnedPropertyNames() {
        WARNED_PROP_NAMES.clear();
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsSet<String> getAllWarnedPropertyNames() {
        return new CommonsHashSet<ICommonsSet<String>>(WARNED_PROP_NAMES);
    }

    @Nonnull
    public static EChange setPropertyValue(@Nonnull String string, boolean bl) {
        return SystemProperties.setPropertyValue(string, Boolean.toString(bl));
    }

    @Nonnull
    public static EChange setPropertyValue(@Nonnull String string, int n) {
        return SystemProperties.setPropertyValue(string, Integer.toString(n));
    }

    @Nonnull
    public static EChange setPropertyValue(@Nonnull String string, long l) {
        return SystemProperties.setPropertyValue(string, Long.toString(l));
    }

    @Nonnull
    public static EChange setPropertyValue(@Nonnull String string, @Nullable String string2) {
        boolean bl;
        if (string2 == null) {
            bl = SystemProperties.removePropertyValue(string) != null;
        } else {
            String string3 = IPrivilegedAction.systemSetProperty(string, string2).invokeSafe();
            boolean bl2 = bl = string3 != null && !string2.equals(string3);
            if (bl) {
                CONDLOG.info(() -> "Set system property '" + string + "' to '" + string2 + "'");
            }
        }
        return EChange.valueOf(bl);
    }

    @Nullable
    public static String removePropertyValue(@Nonnull String string) {
        String string2 = IPrivilegedAction.systemClearProperty(string).invokeSafe();
        if (string2 != null) {
            CONDLOG.info(() -> "Removed system property '" + string + "' with value '" + string2 + "'");
        } else {
            CONDLOG.warn(() -> "Remove system property '" + string + "' failed");
        }
        return string2;
    }

    @Nullable
    public static String getJavaVersion() {
        return SystemProperties.getPropertyValue(SYSTEM_PROPERTY_JAVA_VERSION);
    }

    @Nullable
    public static String getJavaVendor() {
        return SystemProperties.getPropertyValue(SYSTEM_PROPERTY_JAVA_VENDOR);
    }

    @Nullable
    public static String getJavaVendorURL() {
        return SystemProperties.getPropertyValue(SYSTEM_PROPERTY_JAVA_VENDOR_URL);
    }

    @Nullable
    public static String getJavaHome() {
        return SystemProperties.getPropertyValue(SYSTEM_PROPERTY_JAVA_HOME);
    }

    @Nullable
    public static String getJavaClassVersion() {
        return SystemProperties.getPropertyValue(SYSTEM_PROPERTY_JAVA_CLASS_VERSION);
    }

    @Nullable
    public static String getJavaClassPath() {
        return SystemProperties.getPropertyValue(SYSTEM_PROPERTY_JAVA_CLASS_PATH);
    }

    @Nullable
    public static String getJavaLibraryPath() {
        return SystemProperties.getPropertyValue(SYSTEM_PROPERTY_JAVA_LIBRARY_PATH);
    }

    @Nullable
    public static String getOsName() {
        return SystemProperties.getPropertyValue(SYSTEM_PROPERTY_OS_NAME);
    }

    @Nullable
    public static String getOsArch() {
        return SystemProperties.getPropertyValue(SYSTEM_PROPERTY_OS_ARCH);
    }

    @Nullable
    public static String getOsVersion() {
        return SystemProperties.getPropertyValue(SYSTEM_PROPERTY_OS_VERSION);
    }

    @Nullable
    public static String getFileSeparator() {
        return SystemProperties.getPropertyValue(SYSTEM_PROPERTY_FILE_SEPARATOR);
    }

    @Nullable
    public static String getPathSeparator() {
        return SystemProperties.getPropertyValue(SYSTEM_PROPERTY_PATH_SEPARATOR);
    }

    @Nullable
    public static String getLineSeparator() {
        return SystemProperties.getPropertyValue(SYSTEM_PROPERTY_LINE_SEPARATOR);
    }

    @Nullable
    public static String getUserName() {
        return SystemProperties.getPropertyValue(SYSTEM_PROPERTY_USER_NAME);
    }

    @Nullable
    public static String getUserHome() {
        return SystemProperties.getPropertyValue(SYSTEM_PROPERTY_USER_HOME);
    }

    @Nullable
    public static String getUserDir() {
        return SystemProperties.getPropertyValue(SYSTEM_PROPERTY_USER_DIR);
    }

    @Nullable
    public static String getJavaVmName() {
        return SystemProperties.getPropertyValue(SYSTEM_PROPERTY_JAVA_VM_NAME);
    }

    @Nullable
    public static String getJavaVmSpecificationVersion() {
        return SystemProperties.getPropertyValue(SYSTEM_PROPERTY_JAVA_VM_SPECIFICATION_VERSION);
    }

    @Nullable
    public static String getJavaVmSpecificationVendor() {
        return SystemProperties.getPropertyValue(SYSTEM_PROPERTY_JAVA_VM_SPECIFICATION_VENDOR);
    }

    @Nullable
    public static String getJavaVmSpecificationUrl() {
        return SystemProperties.getPropertyValue(SYSTEM_PROPERTY_JAVA_VM_SPECIFICATION_URL);
    }

    @Nullable
    public static String getJavaVmVersion() {
        return SystemProperties.getPropertyValue(SYSTEM_PROPERTY_JAVA_VM_VERSION);
    }

    @Nullable
    public static String getJavaVmVendor() {
        return SystemProperties.getPropertyValue(SYSTEM_PROPERTY_JAVA_VM_VENDOR);
    }

    @Nullable
    public static String getJavaVmUrl() {
        return SystemProperties.getPropertyValue(SYSTEM_PROPERTY_JAVA_VM_URL);
    }

    @Nullable
    public static String getJavaSpecificationVersion() {
        return SystemProperties.getPropertyValue(SYSTEM_PROPERTY_JAVA_SPECIFICATION_VERSION);
    }

    @Nullable
    public static String getJavaSpecificationVendor() {
        return SystemProperties.getPropertyValue(SYSTEM_PROPERTY_JAVA_SPECIFICATION_VENDOR);
    }

    @Nullable
    public static String getJavaSpecificationUrl() {
        return SystemProperties.getPropertyValue(SYSTEM_PROPERTY_JAVA_SPECIFICATION_URL);
    }

    @Nullable
    @DevelopersNote(value="This property is not part of the language but part of the Sun SDK")
    public static String getTmpDir() {
        return SystemProperties.getPropertyValue(SYSTEM_PROPERTY_JAVA_IO_TMPDIR);
    }

    @Nullable
    public static String getJavaRuntimeVersion() {
        return SystemProperties.getPropertyValue(SYSTEM_PROPERTY_JAVA_RUNTIME_VERSION);
    }

    @Nullable
    public static String getJavaRuntimeName() {
        return SystemProperties.getPropertyValue(SYSTEM_PROPERTY_JAVA_RUNTIME_NAME);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsSet<String> getAllPropertyNames() {
        return SystemProperties.getAllProperties().copyOfKeySet();
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsMap<String, String> getAllProperties() {
        Properties properties = IPrivilegedAction.systemGetProperties().invokeSafe();
        if (properties == null) {
            return new CommonsHashMap<String, String>();
        }
        return PropertiesHelper.getAsStringMap(properties);
    }

    public static boolean containsPropertyName(String string) {
        return SystemProperties.getAllProperties().containsKey(string);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static String[] getAllJavaNetSystemProperties() {
        return new String[]{"javax.net.debug", "java.security.debug", "java.net.useSystemProxies", "http.proxyHost", "http.proxyPort", "http.nonProxyHosts", "https.proxyHost", "https.proxyPort"};
    }
}

