/*
 * Decompiled with CFR 0.152.
 */
package com.helger.bc;

import java.security.Provider;
import java.security.Security;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class PBCProvider {
    public static final String PROVIDER_NAME_BC_FIPS = "BCFIPS";
    private static final Logger LOGGER = LoggerFactory.getLogger(PBCProvider.class);
    private static final Provider PROVIDER;
    private static final PBCProvider INSTANCE;

    private PBCProvider() {
    }

    @Nonnull
    public static Provider getProvider() {
        return PROVIDER;
    }

    static {
        Provider provider = Security.getProvider("BC");
        if (provider == null) {
            provider = new BouncyCastleProvider();
            Security.addProvider(provider);
        } else if (!(provider instanceof BouncyCastleProvider)) {
            LOGGER.warn("Security provider 'BC' is not of type org.bouncycastle.jce.provider.BouncyCastleProvider but it is a '" + provider.getClass().getName() + "'");
        }
        PROVIDER = provider;
        INSTANCE = new PBCProvider();
    }
}

