/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.log;

import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.log.IConditionalLogger;
import com.helger.base.state.IEnabledIndicator;
import com.helger.base.tostring.ToStringGenerator;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

@ThreadSafe
public final class ConditionalLogger
implements IConditionalLogger,
IEnabledIndicator {
    public static final boolean DEFAULT_ENABLED = false;
    private final Logger m_aLogger;
    private final AtomicBoolean m_aEnabled;

    public ConditionalLogger(@NonNull Logger logger) {
        this(logger, false);
    }

    public ConditionalLogger(@NonNull Logger logger, boolean bl) {
        ValueEnforcer.notNull(logger, "Logger");
        this.m_aLogger = logger;
        this.m_aEnabled = new AtomicBoolean(bl);
    }

    @Override
    public boolean isEnabled() {
        return this.m_aEnabled.get();
    }

    public boolean setEnabled(boolean bl) {
        return this.m_aEnabled.getAndSet(bl);
    }

    @Override
    public void trace(@NonNull Supplier<String> supplier) {
        if (this.isEnabled() && this.m_aLogger.isTraceEnabled()) {
            this.m_aLogger.trace(supplier.get());
        }
    }

    @Override
    public void trace(@NonNull Supplier<String> supplier, @Nullable Exception exception) {
        if (this.isEnabled() && this.m_aLogger.isTraceEnabled()) {
            this.m_aLogger.trace(supplier.get(), (Throwable)exception);
        }
    }

    @Override
    public void debug(@NonNull Supplier<String> supplier) {
        if (this.isEnabled() && this.m_aLogger.isDebugEnabled()) {
            this.m_aLogger.debug(supplier.get());
        }
    }

    @Override
    public void debug(@NonNull Supplier<String> supplier, @Nullable Exception exception) {
        if (this.isEnabled() && this.m_aLogger.isDebugEnabled()) {
            this.m_aLogger.debug(supplier.get(), (Throwable)exception);
        }
    }

    @Override
    public void info(@NonNull String string) {
        if (this.isEnabled()) {
            this.m_aLogger.info(string);
        }
    }

    @Override
    public void info(@NonNull Supplier<String> supplier) {
        if (this.isEnabled()) {
            this.m_aLogger.info(supplier.get());
        }
    }

    @Override
    public void info(@NonNull String string, @Nullable Exception exception) {
        if (this.isEnabled()) {
            this.m_aLogger.info(string, (Throwable)exception);
        }
    }

    @Override
    public void info(@NonNull Supplier<String> supplier, @Nullable Exception exception) {
        if (this.isEnabled()) {
            this.m_aLogger.info(supplier.get(), (Throwable)exception);
        }
    }

    @Override
    public void warn(@NonNull String string) {
        if (this.isEnabled()) {
            this.m_aLogger.warn(string);
        }
    }

    @Override
    public void warn(@NonNull Supplier<String> supplier) {
        if (this.isEnabled()) {
            this.m_aLogger.warn(supplier.get());
        }
    }

    @Override
    public void warn(@NonNull String string, @Nullable Exception exception) {
        if (this.isEnabled()) {
            this.m_aLogger.warn(string, (Throwable)exception);
        }
    }

    @Override
    public void warn(@NonNull Supplier<String> supplier, @Nullable Exception exception) {
        if (this.isEnabled()) {
            this.m_aLogger.warn(supplier.get(), (Throwable)exception);
        }
    }

    @Override
    public void error(@NonNull String string) {
        if (this.isEnabled()) {
            this.m_aLogger.error(string);
        }
    }

    @Override
    public void error(@NonNull Supplier<String> supplier) {
        if (this.isEnabled()) {
            this.m_aLogger.error(supplier.get());
        }
    }

    @Override
    public void error(@NonNull String string, @Nullable Exception exception) {
        if (this.isEnabled()) {
            this.m_aLogger.error(string, (Throwable)exception);
        }
    }

    @Override
    public void error(@NonNull Supplier<String> supplier, @Nullable Exception exception) {
        if (this.isEnabled()) {
            this.m_aLogger.error(supplier.get(), (Throwable)exception);
        }
    }

    public String toString() {
        return new ToStringGenerator(this).append("Enabled", this.isEnabled()).append("Logger", this.m_aLogger).getToString();
    }
}

