/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.id.factory;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.id.factory.ILongIDFactory;
import com.helger.base.tostring.ToStringGenerator;
import java.util.concurrent.atomic.AtomicLong;

@ThreadSafe
public final class MemoryLongIDFactory
implements ILongIDFactory {
    public static final long DEFAULT_START_ID = 10000L;
    private final AtomicLong m_aID;

    public MemoryLongIDFactory() {
        this(10000L);
    }

    public MemoryLongIDFactory(@Nonnegative long l) {
        ValueEnforcer.isGE0(l, "StartID");
        this.m_aID = new AtomicLong(l);
    }

    @Override
    public long getNewID() {
        return this.m_aID.getAndIncrement();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        MemoryLongIDFactory memoryLongIDFactory = (MemoryLongIDFactory)object;
        return this.m_aID.get() == memoryLongIDFactory.m_aID.get();
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aID.get()).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("ID", this.m_aID).getToString();
    }
}

